<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9510"
	title	= "標準(ﾎﾟｯﾌﾟｱｯﾌﾟ用)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	columns   = "*"
/>
<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- 検索中です表示を出すため、あえて 2秒 待たせます。 -->
<jsp:scriptlet>
	try{ Thread.sleep( 2000L ); } catch( final InterruptedException ex ){}
</jsp:scriptlet>


<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}" stopZero="true" scope="request">
	<!-- 先頭のカラム名が、"WRITABLE" の場合、'true' or '1' で、書き込み許可が与えら,'2' でチェック済みになります。-->
		select 	CASE KBSAKU WHEN '3' THEN '0' ELSE KBSAKU END AS WRITABLE,
				CLM,'_' || NAME_JA as NAME_JA,LABEL_NAME,KBSAKU,SYSTEM_ID,LANG,UNIQ,
				FGJ,USRSET,DYSET,USRUPD,DYUPD
		from GF41
	<og:where>
		<og:and value = "SYSTEM_ID	=  '{@SYSTEM_ID}'"	/>
		<og:and value = "LANG		=  '{@LANG}'"		/>
		<og:and value = "CLM		like '{@CLM}'"		/>
		<og:and value = "CLM"		instrVals="{@CLMS}" instrType="in" />
		<og:and value = "NAME_JA	like '{@NAME_JA}'"	/>
		<og:and value = "LABEL_NAME	like '{@LABEL_NAME}'" />
		<og:and value = "KBSAKU		=    '{@KBSAKU}'"	/>
	</og:where>
	<og:appear startKey = "order by" value = "{@ORDER_BY}"
				defaultVal = "SYSTEM_ID,CLM,LANG" />
</og:query>

<!-- ViewMarkerTag は、指定のカラムをマーキングします。 -->
<og:viewMarker command="{@command}">
	<!-- 名称(漢字) -->
	<og:columnMarker column="NAME_JA" onMark="[KBSAKU]" markList="1">
		<span id="hybs_focus" name="hybs_focus" style="background-color:#ccff00">[NAME_JA]</span>
	</og:columnMarker>
	<!-- 表示名称 -->
	<og:columnMarker column="LABEL_NAME" onMark="[KBSAKU]" markList="3" >
		<font color='red'>[LABEL_NAME]</font>
	</og:columnMarker>
</og:viewMarker>

<!-- DB検索結果を表示させます。 -->
<!-- checked="true" で、チェック済みの状態で表示できます。 -->
<!-- selectedType="checkbox(デフォルト)/radio/hidden" から、選べます。-->
<og:view
	viewFormType = "HTMLTable"
	command      = "{@command}"
	noDisplay    = "UNIQ"
	scope		 = "request"
	selectedType = "radio"
	popupReturnKeys = "SYSTEM_ID,CLM,NAME_JA,LANG,KBSAKU"
/>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
