<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GFX022"
	title	= "ｴﾃﾞｨｯﾄ設定ﾃｽﾄ"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- 変更はここから -->

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="{@debug}" maxRowCount="{@maxRowCount}">
		select  a.VERNO,a.PRE_FIX || ':' || a.TAGNAME as TAGNAME2,
				a.PRE_FIX,a.TAGNAME,a.SEQ,a.SEQ * 1.2345 SEQNO,a.VALUENAME,a.REQUIRED,
				b.DESCRIPTION,b.CONTENTS,b.HTMLEXT,c.BODYCONTENT,'0' as DATAKEY
		from    GF22 a left outer join GF24 b
		on		a.VERNO   = b.VERNO
		and		a.TAGCLASS  = b.TAGCLASS
		and		a.VALUENAME = b.VALUENAME
		and		a.FGJ       = b.FGJ
					left outer join GF21 c
					on	a.VERNO   = c.VERNO
					and	a.PRE_FIX    = c.PRE_FIX
					and	a.TAGNAME   = c.TAGNAME
	<!-- 検索条件でWhereTagを使用すれば{@xxxx}がNULLの場合、その条件は無視されます。 -->
	<og:where>
		<og:and value = "a.VERNO     LIKE '{@VERNO}%'"      />
		<og:and value = "a.PRE_FIX      =    '{@PRE_FIX}'"        />
		<og:and value = "upper(a.TAGNAME)     LIKE upper('{@TAGNAME}%')"      />
		<og:and value = "a.VALUENAME   LIKE '{@VALUENAME}%'"    />
		<og:and value = "b.DESCRIPTION LIKE '%{@DESCRIPTION}%'" />
		<og:and value = "a.PRE_FIX || ':' || a.TAGNAME = '{@FULLTAG}'" />
		<og:and value = "a.FGJ         in   ( '0','1' )"        />
	</og:where>
	<og:equals val1="{@VIEW}" val2="XML" >
			union
			select VERNO,PRE_FIX || ':' || TAGNAME as TAGNAME2,PRE_FIX,TAGNAME,99 as SEQ,
					'' as VALUENAME,'' as REQUIRED,'' as DESCRIPTION,'' as CONTENTS,'' as HTMLEXT,
					BODYCONTENT,BODYCONTENT as DATAKEY
			from GF21
		<og:where>
			<og:and value = "VERNO     LIKE '{@VERNO}%'"      />
			<og:and value = "PRE_FIX      =    '{@PRE_FIX}'"        />
			<og:and value = "TAGNAME     LIKE '{@TAGNAME}%'"      />
			<og:and value = "FGJ         in   ( '0','1' )"        />
		</og:where>
	</og:equals>
	<!-- ORDER BY句でAppearTagを使用すれば{@ORDER_BY}がNULLの場合、ORDER BY句は無視されます。 -->
	<!-- また、{@ORDER_BY}がNULLの場合に、defaultVal属性を指定すれば、その値でORDER BY表示されます。 -->
	<og:appear startKey="order by" value="{@SORT}" defaultVal="a.VERNO,a.TAGNAME,a.SEQ" />
</og:query>

<!-- ColumnEditorTagを使用すると、登録画面の入力フィールドで、入力の必須状態を表したり(must="true"を使用)、 -->
<!-- DBからの検索結果を、コンボボックスでプルダウン表示させる(editor="DBMENU"を使用)ことが可能となります。 -->

<og:columnEditor column="SEQ" label="POINT" />
<og:columnEditor column="SEQNO" label="POINT2" />

<og:viewLink command="{@command}">
	<og:link column="TAGNAME2" gamenId="DOC01" href="index.jsp" target="CONTENTS"
			keys="command,VERNO,PRE_FIX,TAGNAME,VIEW" vals="NEW,[VERNO],[PRE_FIX],[TAGNAME],FULL" />
	<og:link column="VALUENAME" gamenId="DOC02" href="index.jsp" target="CONTENTS"
			keys="command,VERNO,PRE_FIX,TAGNAME,VALUENAME,VIEW" vals="NEW,[VERNO],[PRE_FIX],[TAGNAME],[VALUENAME],FULL" />
</og:viewLink>

<og:equals val1="{@VIEW}" nullCheck="true" >
<og:view
	viewFormType = "HTMLTable"
	command 	 = "{@command}"
	noDisplay	 = "CONTENTS,PRE_FIX,TAGNAME"
	writable     = "false"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}" />
</og:equals>

<og:equals val1="{@VIEW}" val2="FULL" >
<!-- DB検索結果を表示させます。 -->
<og:view
	viewFormType = "HTMLFormatTable"
	command 	 = "{@command}"
	startNo      = "{@startNo}"
	writable     = "false"
	pageSize     = "{@pageSize}"
	rowspan      = "1"
>
<tr><td valign="top">[VERNO]<br />[TAGNAME2]<br />[VALUENAME]<br />[REQUIRED]<br />[HTMLEXT]<br />[BODYCONTENT]</td>
	<td valign="top"><pre>[CONTENTS]</pre></td>
</tr>
</og:view>
</og:equals>

<og:equals val1="{@VIEW}" val2="XML" >
<og:viewMarker command="{@command}">
	<og:columnMarker column="DESCRIPTION"  onMark="[REQUIRED]" markList="1" >
		<span style="color:green;">[DESCRIPTION]({@LBL.REQUIRED})</span>
	</og:columnMarker>
</og:viewMarker>

<og:view
	viewFormType = "HTMLCustomTable"
	command 	 = "{@command}"
	writable     = "false"
	startNo      = "{@startNo}"
	pageSize     = "{@pageSize}"
	rowspan		 = "1"
	numberType	 = "delete"
>
	<og:thead rowspan="1" >
		<tr><td>&amp;nbsp;</td><td>[VALUENAME]</td><td>[DESCRIPTION]</td></tr>
	</og:thead>

	<og:tbody usableKey="SEQ" usableList="1" rowspan="1">
		<tr><td colspan="2">&amp;lt;[TAGNAME2]</td><td></td></tr>
	</og:tbody>

	<og:tbody usableKey="DATAKEY" usableList="0" rowspan="1">
		<tr><td>&amp;nbsp;&amp;nbsp;</td><td>[VALUENAME]</td>
			<td>= "[DESCRIPTION]"</td></tr>
	</og:tbody>

	<og:tbody usableKey="DATAKEY" usableList="1" rowspan="2">
		<tr><td>&amp;gt;</td><td>... Body ...</td><td></td></tr>
		<tr><td colspan="3">&amp;lt;/[TAGNAME2]&amp;gt;</td></tr>
		<tr><td colspan="3">&amp;nbsp;</td></tr>
	</og:tbody>

	<og:tbody usableKey="DATAKEY" usableList="2" rowspan="1">
		<tr><td>/&amp;gt;</td><td></td><td></td></tr>
		<tr><td colspan="3">&amp;nbsp;</td></tr>
	</og:tbody>
</og:view>

</og:equals>

<!-- ここまで。 -->
	<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
