<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="query" >
	<script src="http://maps.google.com/maps/api/js?sensor=false"><!-- --></script>
	<script>
		// 初期化
		var zoom = 14;
		var mapTypeId = google.maps.MapTypeId.ROADMAP;
		var directionsDisplay = new google.maps.DirectionsRenderer();
		var directionsService = new google.maps.DirectionsService();
		var map;
		var directionmarkers = [];

		var origin;
		var waypoints = [];

		window.onload = initialize;

		// 初期処理
		function initialize(){
			var latlng = new google.maps.LatLng("34.966","135.754");

			origin = latlng;

			var myOptions = {
				zoom : zoom,
				center : latlng,
				mapTypeId : mapTypeId
			};

			// MAP情報の生成
			map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);
			directionsDisplay.setMap(map);
			directionsDisplay.setPanel(document.getElementById("directionsPanel"));
			google.maps.event.addListener(map, 'click', function(event){
				clickLang = event.latLng;
				destination = clickLang;
				addMarker(clickLang);});
		}

		// ﾏｰｶｰの作成
		function addMarker(latLng){
			directionmarkers.push(new google.maps.Marker({
				position:latLng,
				map:map}));
		}

		// ﾙｰﾄ検索
		function calcRoute(){
			var request = {
				origin:origin,											// 始点
				destination:destination,								// 終点
				travelMode: google.maps.DirectionsTravelMode.DRIVING,	// ドライビングモード指定:車
				unitSystem: google.maps.DirectionsUnitSystem.METRIC,	// 単位km表
				optimizeWaypoints: true,								// 最適化された最短距離にする。
				avoidHighways: true,									// trueで高速道路を使用しない
				avoidTolls: true										// trueで有料道路を使用しない
			};

			directionsService.route(request, function(response, status){
				if (status == google.maps.DirectionsStatus.OK)
				{
					directionsDisplay.setDirections(response);
				}
			});
		}
	</script>
</og:head>
<jsp:directive.include file="/jsp/custom/query_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "TEST10"
	title	= "GoogleMap"
	date	= "2015/09/05"
	author	= "Takahashi Masakazu"
	text	= ""
	version	= "001"
/>
<form method="GET" action="forward.jsp" target="RESULT" onSubmit="timeSet();">

<og:message comment="１点をｸﾘｯｸしてから、ﾙｰﾄ検索を押下して下さい。" /><br />
<og:message comment="※複数選択で経過ﾙｰﾄを作成することも可能ですが、実装していません。" /><br />

<!-- 変更はここから -->
<table summary="layout" >
<tr>
	<og:button type="button" onClick="calcRoute();" lbl="ﾙｰﾄ検索" />
</tr>
</table>
</form>

<div style="width:900px;">
<!-- 地図 -->
<div id="map_canvas" style="float:left; left:30px; top:30px; width:500px;height:500px"><!-- --></div>
<!-- ﾙｰﾄ計算 -->
<div id="directionsPanel" style="float:right; width:300px; height:500px;"><!-- --></div>
</div>
<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
