/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.io;

import java.io.File;
import java.util.function.Supplier;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.model.FileOperationFactory;
import org.opengion.fukurou.util.FileUtil;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public final class HybsFileOperationFactory {
    private static final String STORAGE = HybsSystem.sys("CLOUD_TARGET");
    private static final String BUCKET = HybsSystem.sys("CLOUD_BUCKET");

    private HybsFileOperationFactory() {
    }

    public static FileOperation create(boolean bl, String string) {
        String string2 = bl ? "LOCAL" : BUCKET;
        return FileOperationFactory.newStorageOperation((String)STORAGE, (String)string2, (String)string);
    }

    public static FileOperation create(boolean bl, String string, String string2) {
        String string3 = bl ? "LOCAL" : BUCKET;
        return FileOperationFactory.newStorageOperation((String)STORAGE, (String)string3, (String)string, (String)string2);
    }

    public static FileOperation create(boolean bl, File file, String string) {
        return HybsFileOperationFactory.create(bl, new File(file, string).getPath());
    }

    public static boolean useCloud() {
        boolean bl = StringUtil.isNull((CharSequence[])new CharSequence[]{STORAGE, BUCKET}) || "LOCAL".equalsIgnoreCase(STORAGE) || "LOCAL".equalsIgnoreCase(BUCKET);
        return !bl;
    }

    public static void local2cloud(boolean bl, Supplier<File> supplier) {
        if (!bl && HybsFileOperationFactory.useCloud()) {
            File file = supplier.get();
            FileOperation fileOperation = HybsFileOperationFactory.create(false, file.getPath());
            FileUtil.copy((File)file, (File)fileOperation);
        }
    }

    public static void cloud2local(boolean bl, Supplier<File> supplier) {
        if (!bl && HybsFileOperationFactory.useCloud()) {
            File file = supplier.get();
            FileOperation fileOperation = HybsFileOperationFactory.create(false, file.getPath());
            file.delete();
            File file2 = file.getParentFile();
            if (file2 != null) {
                file2.mkdirs();
            }
            FileUtil.copy((File)fileOperation, (File)file);
        }
    }

    public static FileOperation createDir(boolean bl, String string) {
        FileOperation fileOperation = HybsFileOperationFactory.create(bl, string);
        if (bl || !HybsFileOperationFactory.useCloud()) {
            if (!fileOperation.exists() && !fileOperation.mkdirs()) {
                throw new IllegalArgumentException("Not make directory: " + string);
            }
            if (!fileOperation.isDirectory()) {
                throw new IllegalArgumentException("Not a directory: " + string);
            }
            if (!fileOperation.canWrite()) {
                throw new IllegalArgumentException("Not writable: " + string);
            }
        }
        return fileOperation;
    }
}

