/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.report2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.report2.TagParser;

class OdsSheet {
    private static final String ROW_START_TAG = "<table:table-row ";
    private static final String ROW_END_TAG = "</table:table-row>";
    private static final String SHEET_NAME_START = "table:name=\"";
    private static final String END_KEY = "\"";
    private static final String VAR_START = "{@";
    private static final String VAR_END = "}";
    private static final String FORMAT_LINE = "FORMATLINE";
    private static final String DUMMY_LINE = "DUMMYLINE";
    private static final String COPY_LINE = "COPYLINE";
    private final List<String> sheetRows = new ArrayList<String>();
    private final Map<String, String> rowsMap = new HashMap<String, String>();
    private int offsetCnt = -1;
    private String[] bodyTypes;
    private String sheetHeader;
    private String sheetFooter;
    private String sheetName;
    private String origSheetName;
    private String confSheetName;

    public void analyze(String string, String[] stringArray) {
        int n;
        this.bodyTypes = stringArray;
        String[] stringArray2 = TagParser.tag2Array(string, ROW_START_TAG, ROW_END_TAG);
        this.sheetHeader = stringArray2[0];
        this.sheetFooter = stringArray2[1];
        for (n = 2; n < stringArray2.length; ++n) {
            this.lineCopy(stringArray2[n]);
        }
        this.origSheetName = this.sheetName = TagParser.getValueFromTag(this.sheetHeader, SHEET_NAME_START, END_KEY);
        this.confSheetName = null;
        if (this.sheetName != null && (n = this.sheetName.indexOf("__")) > 0 && !this.sheetName.endsWith("__")) {
            this.confSheetName = this.sheetName.substring(n + 2);
            this.sheetName = this.sheetName.substring(0, n);
        }
    }

    private void lineCopy(String string) {
        String string2 = TagParser.splitSufix(string, FORMAT_LINE);
        if (string2 != null) {
            String string3;
            if (this.offsetCnt < 0) {
                this.offsetCnt = this.sheetRows.size();
            }
            if ((string3 = this.rowsMap.get("B" + string2)) == null) {
                this.rowsMap.put("B" + string2, string);
            } else {
                this.rowsMap.put("B" + string2, string3 + string);
            }
            return;
        }
        int n = string.indexOf("{@DUMMYLINE");
        if (n >= 0) {
            if (this.offsetCnt < 0) {
                this.offsetCnt = this.sheetRows.size();
            }
            this.sheetRows.add(string);
            return;
        }
        int n2 = string.indexOf("{@COPYLINE");
        if (n2 >= 0) {
            if (this.offsetCnt < 0) {
                this.offsetCnt = this.sheetRows.size();
            }
            for (int i = 0; i < this.bodyTypes.length; ++i) {
                this.sheetRows.add(string);
            }
            return;
        }
        this.sheetRows.add(string);
    }

    public String getHeader() {
        return this.sheetHeader;
    }

    public String getFooter() {
        return this.sheetFooter;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public String getConfSheetName() {
        return this.confSheetName;
    }

    public String getOrigSheetName() {
        return this.origSheetName;
    }

    public String getRow(final int n, int n2) {
        boolean bl;
        String string = this.sheetRows.get(n);
        boolean bl2 = bl = string.contains("{@DUMMYLINE") || string.contains("{@COPYLINE");
        if (bl) {
            int n3 = n - this.offsetCnt + n2;
            String string2 = n3 < this.bodyTypes.length ? this.rowsMap.getOrDefault(this.bodyTypes[n3], string) : string;
            return new TagParser(){

                @Override
                protected void exec(String string, StringBuilder stringBuilder, int n2) {
                    String string2 = TagParser.checkKey(string, stringBuilder);
                    if (string2.indexOf(60) >= 0) {
                        String string3 = "[ERROR]SHEET:{@\u3068}\u306e\u6574\u5408\u6027\u304c\u4e0d\u6b63\u3067\u3059\uff61" + HybsConst.CR + "\u5909\u6570\u5185\u306e\u7279\u5b9a\u306e\u6587\u5b57\u5217\u306b\u66f8\u5f0f\u8a2d\u5b9a\u304c\u3055\u308c\u3066\u3044\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\uff61\uff77\uff70=" + string2;
                        throw new HybsSystemException(string3);
                    }
                    TagParser.SplitKey splitKey = new TagParser.SplitKey(string2);
                    stringBuilder.append(OdsSheet.VAR_START).append(splitKey.incrementKey(n - OdsSheet.this.offsetCnt)).append(OdsSheet.VAR_END);
                }
            }.doParse(string2, VAR_START, VAR_END, false);
        }
        return string;
    }

    public int getRowCnt() {
        return this.sheetRows.size();
    }
}

