/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.opengion.fukurou.db.ApplicationInfo;
import org.opengion.fukurou.db.DBUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.resource.LabelData;

final class LabelDataLoader {
    private final String DBID = HybsSystem.sys("RESOURCE_DBID");
    private static final String QUERY = "select CLM,SNAME,LNAME,DESCRIPTION,FGLOAD,UNIQ,SYSTEM_ID,KBSAKU from GEA08 where SYSTEM_ID=? and LANG=? and FGJ='1' order by KBSAKU,CLM";
    private static final String QUERY2 = "select CLM,SNAME,LNAME,DESCRIPTION,FGLOAD,UNIQ,SYSTEM_ID,KBSAKU from GEA08 where SYSTEM_ID=? and LANG=? and CLM=? and FGJ='1' order by KBSAKU DESC";
    private static final boolean IS_FGLOAD_AUTOSET = HybsSystem.sysBool("USE_FGLOAD_AUTOSET");
    private static final String UPDATE2 = "update GEA08 set FGLOAD='2' where UNIQ=? and CLM=?";
    private final Map<String, LabelData> labelMap = Collections.synchronizedMap(new WeakHashMap());
    private final String[] SYS_ARRAY;
    private final String LANG;
    public static final boolean USE_DB_APPLICATION_INFO = HybsSystem.sysBool("USE_DB_APPLICATION_INFO");
    private final ApplicationInfo appInfo;

    LabelDataLoader(String[] stringArray, String string, boolean bl) {
        this.SYS_ARRAY = stringArray;
        this.LANG = string;
        if (USE_DB_APPLICATION_INFO) {
            this.appInfo = new ApplicationInfo();
            this.appInfo.setClientInfo(this.SYS_ARRAY[0], HybsSystem.HOST_ADRS, HybsSystem.HOST_NAME);
            this.appInfo.setModuleInfo("LabelDataLoader", null, null);
        } else {
            this.appInfo = null;
        }
        if (bl) {
            this.loadDBResource();
        }
    }

    private void loadDBResource() {
        int n = this.SYS_ARRAY.length;
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = n - 1; i >= 0; --i) {
            String string = this.SYS_ARRAY[i];
            String[] stringArray = new String[]{string, this.LANG};
            String[][] stringArray2 = DBUtil.dbExecute((String)QUERY, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
            int n3 = stringArray2.length;
            n2 += n3;
            for (int j = 0; j < n3; ++j) {
                String string2 = stringArray2[j][0];
                if ("1".equals(stringArray2[j][4])) {
                    this.labelMap.put(string2, new LabelData(stringArray2[j]));
                    int n4 = i;
                    nArray[n4] = nArray[n4] + 1;
                    continue;
                }
                if (this.labelMap.get(string2) == null) continue;
                this.labelMap.remove(string2);
            }
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("  ").append(this.SYS_ARRAY[0]).append("  LabelDataLoader [").append(n2).append("] Map=[").append(this.labelMap.size()).append("] ");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.SYS_ARRAY[i]).append("=[").append(nArray[i]).append("] ");
        }
        stringBuilder.append("loaded.");
        System.out.println(stringBuilder);
    }

    public LabelData getLabelData(String string) {
        LabelData labelData = this.labelMap.get(string);
        if (labelData == null) {
            for (String string2 : this.SYS_ARRAY) {
                String[] stringArray = new String[]{string2, this.LANG, string};
                String[][] stringArray2 = DBUtil.dbExecute((String)QUERY2, (String[])stringArray, (ApplicationInfo)this.appInfo, (String)this.DBID);
                if (stringArray2.length <= 0) continue;
                labelData = new LabelData(stringArray2[0]);
                if (!IS_FGLOAD_AUTOSET) break;
                String string3 = stringArray2[0][4];
                String string4 = stringArray2[0][6];
                if ("1".equals(string3) || "2".equals(string3) || "**".equals(string4)) break;
                String[] stringArray3 = new String[]{stringArray2[0][5], string};
                DBUtil.dbExecute((String)UPDATE2, (String[])stringArray3, (ApplicationInfo)this.appInfo, (String)this.DBID);
                break;
            }
            if (labelData == null) {
                labelData = new LabelData(string);
            }
            this.labelMap.put(string, labelData);
        }
        return labelData;
    }

    public Map<String, LabelData> getLabelMap(String string, String string2) {
        if (string == null || string.isEmpty()) {
            throw new HybsSystemException("\u30e9\u30d9\u30eb\u3092\u53d6\u5f97\u3059\u308b\u30af\u30a8\u30ea\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        String[][] stringArray = DBUtil.dbExecute((String)string, null, (ApplicationInfo)this.appInfo, (String)string2);
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        int n = stringArray[0].length;
        if (n < 2) {
            String string3 = "\u30e9\u30d9\u30eb\u30ad\u30fc\u3001\u30e9\u30d9\u30eb\u540d\u79f0\u306e\u6307\u5b9a\u306f\u5fc5\u9808\u3067\u3059\u3002 SQL=" + string;
            throw new HybsSystemException(string3);
        }
        HashMap<String, LabelData> hashMap = new HashMap<String, LabelData>();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = new String[]{stringArray[i][0], n == 2 ? stringArray[i][1] : stringArray[i][2], stringArray[i][1], "", ""};
            hashMap.put(stringArray[i][0], new LabelData(stringArray2));
        }
        return hashMap;
    }

    public void clear(String string) {
        this.labelMap.remove(string);
    }

    public void clear() {
        this.labelMap.clear();
    }
}

