<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF2070"
	title	= "ARG変数検証(GF81)"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command   = "{@command}"
	columns   = "SYSTEM_ID,OBJ_NAME"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command = "{@command}" />

<og:query command="{@command}" maxRowCount="{@maxRowCount}" quotCheck="false" >
	select SYSTEM_ID,TBLSYU,OBJ_NAME,SEQNO,CLM ,CLS_NAME,USE_LENGTH,
			TABLE_NAME,MAX_LENGTH,CLM_NAME,FGJ,UNIQ
	from GF81
	<og:where>
		<og:and value="SYSTEM_ID	=    '{@SYSTEM_ID}'"	/>
		<og:and value="TBLSYU		=    '{@TBLSYU}'"		/>
		<og:and value="OBJ_NAME		like '{@OBJ_NAME}'"		/>
		<og:and value="CLM			like '{@CLM}'"			/>
		<og:and value="CLS_NAME		like '{@CLS_NAME}'"		/>
		<og:and value="USE_LENGTH	=    '{@USE_LENGTH}'"	/>
		<og:and value="TABLE_NAME	like '{@TABLE_NAME}'"	/>
		<og:and value="( '{@LEN_CK}'    = '1' and USE_LENGTH != MAX_LENGTH )"	/>
		<og:and value="( '{@NAME_NULL}' = '1' and ( CLM_NAME IS NULL OR CLM = CLM_NAME ) )" />
		<og:and value="( '{@MLEN_NULL}' = '1' and MAX_LENGTH IS NULL )"			/>
		<og:and value="( '{@TBL_NULL}'  = '1' and TABLE_NAME IS NULL )"			/>
	</og:where>
	<og:appear startKey="order by" value="{@ORDER_BY}"
				defaultVal="SYSTEM_ID,TBLSYU,OBJ_NAME,SEQNO" />
</og:query>

<form method="POST" action="forward.jsp" target="RESULT">
<og:writeCheck>
	<og:submit action="COPY"	keys="noWritable"		vals="null" />
	<og:submit action="MODIFY"	keys="noWritable"		vals='"SYSTEM_ID,TBLSYU,OBJ_NAME,CLM"'   />
	<og:submit action="DELETE"	keys="columnWritable"	vals="null" />
	<og:fieldset lbl="INSERT_GF81">
		<og:column  name="DBID"			codeKeyVal="{@DBID_INFO}" td="no" />
		<og:column  name="SYSTEM_ID"	size="5" td="no" defaultVal="{@SYSTEM_ID}" />
		<og:column  name="TBLSYU"		addNoValue="false" td="no" defaultVal="{@TBLSYU}"  />
		<og:submit  value="directGF81" lbl="DIRECT" command="INSERT" />
	</og:fieldset>
	<br />
</og:writeCheck>

<og:view
	viewFormType = "HTMLTable"
	command		= "{@command}"
	noDisplay	= "UNIQ,FGJ"
	startNo		= "{@startNo}"
	pageSize	= "{@pageSize}"
/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
