<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">

<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "GF9110"
	title	= "標準(タグ)"
	date	= "2008/10/27"
	author	= "Kazuhiko HASEGAWA"
	text	= ""
	version	= "001"
/>
<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />
<!-- 入力チェック -->
<og:columnCheck
	command   = "{@command}"
	nullCheck = "JSON"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<!-- DB検索 SQL文記述 debug="true" でSQL文を確認できます。-->
<og:query command="{@command}" debug="true" maxRowCount="{@maxRowCount}" stopZero="true">
	<og:iorSQL reqKey="JSON" loadFile="{@LOAD_FILE}" />
</og:query>

<og:equals val1="{@SAVE_FILE}" isNull="true" >
	<!-- DB検索結果を表示させます。 -->
	<og:view
		viewFormType	= "HTMLTable"
		command			= "{@command}"
		checked			= "{@checked}"
		startNo			= "{@startNo}"
		pageSize		= "{@pageSize}"
	/>
</og:equals>

<og:equals val1="{@SAVE_FILE}" notNull="true" >
	<!-- ファイルに出力して、forward します。 -->
	<og:writeTable
		writerClass		= "JSON2"
		fileURL			= "{@USER.ID}"
		filename		= "{@SAVE_FILE}"
		debug			= "{@debug}"
	/>
	<og:forward page="{@SYS.FILE_OUT_URL}{@USER.ID}/{@SAVE_FILE}" filename="{@SAVE_FILE}" />
</og:equals>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
