<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld" 
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="init" />
<og:comment
	system	= "GF:エンジンサンプル"
	pgid	= "ORA09"
	title	= "SQL洗い出し"
	date	= "2008/10/27"
	author	= "Hiroki.Nakamura"
	text	= ""
	version	= "001"
/>


<og:query command="{@command}" debug="{@debug}" scope="request" dbid="{@DBID}">
		select depth,lpad(' ',depth,' ') ||
				 rtrim( OPERATION ) || ' ' ||
				 rtrim( OPTIONS )   || ' ' ||
				 rtrim( OBJECT_NAME ) as EXECUTION_PLAN
				,decode( instr(OPTIONS,'FULL'),null,'false',0,'false','true' ) as FULL
				,optimizer,object_name,cost,cardinality,bytes
		 from
		     v$sql_plan
		 where
		     SQL_ID = '{@SQL_ID}'
		 start with id = 0
		 connect by
		     ( prior id = parent_id
		       and prior SQL_ID = SQL_ID
		       and prior child_number=child_number
		     )
		order siblings by id, position
</og:query>

<og:viewMarker command="{@command}" >
	<og:columnMarker column="EXECUTION_PLAN" onMark="[FULL]" >
		<span id="warning">[EXECUTION_PLAN]</span>
	</og:columnMarker>
</og:viewMarker>

<og:columnEditor column="EXECUTION_PLAN" renderer="PRE" scope="request" />

<og:view
	scope        = "request"
	viewFormType = "HTMLTable"
	command    = "{@command}"
	writable   = "false"
	startNo    = "{@startNo}"
	pageSize   = "10000" />

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
