/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.fukurou.business;

import org.opengion.fukurou.util.ErrorMessage;

/**
 * ﾊﾟﾗﾒｰﾀｰのみを使用する(ﾒｲﾝｶｰｿﾙを定義しない)業務ﾛｼﾞｯｸの構造を定義します｡
 *
 * このｸﾗｽでは､以下に示すﾒｿｯﾄﾞが呼び出されるﾀｲﾐﾝｸﾞのみを定義しています｡
 * ﾒｿｯﾄﾞの中身については､ｻﾌﾞｸﾗｽでｵｰﾊﾞｰﾗｲﾄﾞし実装して下さい｡
 *
 * 処理が途中で中断される条件は､以下の3つです｡
 * ①各ﾒｿｯﾄﾞの戻り値がfalseの場合
 * ②ﾁｪｯｸﾒｿｯﾄﾞ(check())が全ての行で実装された後､ｴﾗｰﾒｯｾｰｼﾞに"ｴﾗｰ"が含まれている場合
 * ③実行時ｴﾗｰが発生した場合
 *
 *  check()  ﾊﾟﾗﾒｰﾀｰﾁｪｯｸ 1回のみ呼び出し
 *  logic()  ﾒｲﾝ処理           1回のみ呼び出し
 *
 * @og.rev 5.1.1.0 (2009/12/01) 新規作成
 * @og.group 業務ﾛｼﾞｯｸ
 *
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */
public class BizLogic_ENTRY extends AbstractBizLogic {

	/**
	 * ﾃﾞﾌｫﾙﾄｺﾝｽﾄﾗｸﾀｰ
	 *
	 * @og.rev 6.4.2.0 (2016/01/29) PMD refactoring. Each class should declare at least one constructor.
	 */
	public BizLogic_ENTRY() { super(); }		// これも､自動的に呼ばれるが､空のﾒｿｯﾄﾞを作成すると警告されるので､明示的にしておきます｡

	/**
	 * 処理のﾒｲﾝﾛｼﾞｯｸの前処理を記述します｡
	 * (ここでは何もしません)
	 *
	 * このﾒｿｯﾄﾞ自体は､protected属性であるため､ｻﾌﾞｸﾗｽから直接参照することができます｡
	 * 但し､これは､各業務ﾛｼﾞｯｸで直接参照することを想定したものではなく､BizLogicの
	 * ﾒｲﾝ構造を拡張するｻﾌﾞｸﾗｽを定義する際に使用することを想定しています｡
	 * (この想定がなければ､本来は､package privateにすべきです)
	 * このため､業務ﾛｼﾞｯｸを各実装ｸﾗｽでは直接参照しないで下さい｡
	 */
	@Override
	protected void init() {
		// Document empty method ﾁｪｯｸ対策
	}

	/**
	 * 処理のﾒｲﾝﾛｼﾞｯｸを記述します｡
	 *
	 * このﾒｿｯﾄﾞ自体は､protected属性であるため､ｻﾌﾞｸﾗｽから直接参照することができます｡
	 * 但し､これは､各業務ﾛｼﾞｯｸで直接参照することを想定したものではなく､BizLogicの
	 * ﾒｲﾝ構造を拡張するｻﾌﾞｸﾗｽを定義する際に使用することを想定しています｡
	 * (この想定がなければ､本来は､package privateにすべきです)
	 * このため､業務ﾛｼﾞｯｸを各実装ｸﾗｽでは直接参照しないで下さい｡
	 *
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean main() {
		row = 0;

		// 6.4.1.1 (2016/01/16) PMD refactoring. A method should have only one exit point, and that should be the last statement in the method
		// 条件判定注意
		return check() && getKekka() < ErrorMessage.NG && logic();
	}

	/**
	 * ﾁｪｯｸﾛｼﾞｯｸを定義します｡
	 * ここでは何も実装されていません｡
	 *
	 * @return 処理が正常終了したか
	 */
	protected boolean check() {
		return true;
	}

	/**
	 * ﾒｲﾝ処理を定義します｡
	 * ここでは何も実装されていません｡
	 *
	 * @return 処理が正常終了したか
	 */
	protected boolean logic() {
		return true;
	}
}
