/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.db.AbstractDBType;

/**
 * ﾊﾟｽﾜｰﾄﾞ情報等の重要な情報のﾊｯｼｭｺｰﾄﾞ(SHA-256)を扱う為のｶﾗﾑ属性を定義します｡
 *
 * ﾊﾟｽﾜｰﾄﾞ情報等の重要な情報のﾊｯｼｭｺｰﾄﾞに SHA-256 があります｡
 * このｸﾗｽは、MessageDigestにより SHA-256 でﾊｯｼｭした文字を作成します｡
 *
 * MD5やSHA-1は脆弱性が報告されているため、可能であればSHA-256の利用が推奨されます｡
 *
 * 値としては､標準の X と同じ半角文字列｢ c &lt; 0x20 || c &gt; 0x7e 以外｣でのみ
 * 処理することが出来ます｡
 *
 * ﾀｲﾌﾟﾁｪｯｸとして、以下の条件を判定します｡
 * ･文字列長はByte換算での文字数との比較
 * ･半角文字列ﾁｪｯｸ｢ c &lt; 0x20 || c &gt; 0x7e 以外｣ｴﾗｰ
 * ･文字ﾊﾟﾗﾒｰﾀの正規表現ﾁｪｯｸ
 * ･ｸﾛｽｻｲﾄｽｸﾘﾌﾟﾃｨﾝｸﾞﾁｪｯｸ
 *
 * @og.group ﾃﾞｰﾀ属性
 *
 * @version  7.0
 * @author   Takahashi Masakazu
 * @since    JDK11.0,
 */
// public class DBType_SHA512 extends AbstractDBType {
public class DBType_SHA extends AbstractDBType {						// 7.1.0.0 (2020/01/27) クラス名変更
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "8.1.2.0 (2022/03/10)" ;

	/**
	 * ﾃﾞﾌｫﾙﾄｺﾝｽﾄﾗｸﾀｰ
	 *
	 * @og.rev 7.0.4.0 (2019/05/31) PMD Each class should declare at least one constructor
	 */
//	public DBType_SHA512() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。
	public DBType_SHA() { super(); }		// 7.1.0.0 (2020/01/27)

	/**
	 * String引数の文字列を＋１した文字列を返します｡
	 * ※ このｸﾗｽでは実装されていません｡
	 *
	 * @param	value	String引数の文字列
	 * @throws	UnsupportedOperationException このｸﾗｽを実行すると､必ず発生します｡
	 *
	 * @return	String引数の文字列を＋１した文字列
	 */
	@Override
	public String valueAdd( final String value ) {
		final String errMsg = "valueAdd ﾒｿｯﾄﾞは、DBType_SHA ｸﾗｽからは使用できません｡";
		throw new UnsupportedOperationException( errMsg );
	}

	/**
	 * MessageDigestにより SHA-256 でﾊｯｼｭした文字を返します｡
	 *
	 * ﾏｲﾅｽ時には符号を反転させて、16進数で文字列に変換しています｡
	 * よって、このﾒｿｯﾄﾞで変換した文字でのみ突き合わせて正しいかどうかを
	 * 判断してください｡
	 *
	 * @og.rev 8.1.2.0 (2022/03/10) ﾊｯｼｭｺｰﾄﾞを SHA-512 から SHA-256 に変更
	 *
	 * @param	value	(一般に編集ﾃﾞｰﾀとして登録されたﾃﾞｰﾀ)
	 *
	 * @return	修正後の文字列(一般にﾃﾞｰﾀﾍﾞｰｽに登録するﾃﾞｰﾀ)
	 */
	@Override
	public String valueSet( final String value ) {
//		return HybsCryptography.getSHA512( StringUtil.rTrim( value ) );			// 8.1.2.0 (2022/03/10) Modify
		return HybsCryptography.getHash( "SHA-256", StringUtil.rTrim( value ) );
	}
}
