/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.opengion.plugin.column;

import org.opengion.hayabusa.db.AbstractEditor;
import org.opengion.hayabusa.db.CellEditor;
import org.opengion.hayabusa.db.DBColumn;
// import org.opengion.fukurou.util.XHTMLTag;						// 8.0.0.0 (2021/07/31) Delete
// import org.opengion.hayabusa.common.HybsSystem;					// 8.0.0.0 (2021/07/31) Delete
// import org.opengion.fukurou.util.Attributes;						// 8.0.0.0 (2021/07/31) Delete
// import org.opengion.fukurou.util.StringUtil;						// 8.0.0.0 (2021/07/31) Delete
// import org.opengion.fukurou.util.TagBuffer;						// 8.0.0.0 (2021/07/31) Delete

/**
 * SNAP エディターは、カメラ映像で取り込んだvideoをcanvasにｷｬﾌﾟﾁｬしてから、
 * BASE64ｴﾝｺｰﾄﾞでｻｰﾊﾞｰにｱｯﾌﾟﾛｰﾄﾞするクラスです。
 * ｾｰﾌﾞﾌｫﾙﾀﾞは、ｻｰﾌﾞﾚｯﾄの初期値(saveDir) + 相対ﾊﾟｽで、値(value値) を使用します。
 * ﾌｧｲﾙ名は、初期値(yyyyMMddHHmmssSSS.png)か、引数 file を使用します。
 * 受け側(ｻｰﾊﾞｰ側)は、ImageSave ｻｰﾌﾞﾚｯﾄを使用します。
 *
 * 基本的な構造は、カメラ映像描画開始ボタン、静止画キャプチャボタン、ｱｯﾌﾟﾛｰﾄﾞﾎﾞﾀﾝ、
 * 映像表示領域(video)、静止画描画領域(canvas)、ﾌｧｲﾙ名設定ﾃｷｽﾄﾌｨｰﾙﾄﾞで構成されます。
 * 映像表示領域(video)でｷｬﾌﾟﾁｬすると、静止画を同じ場所に上書きします。もう一度押すと再度映像に切り替わります。
 *
 *    &lt;button type='button' id='vidStart' onClick='videoStart()'&gt;Video Start&lt;/button&gt;
 *    &lt;button type='button' id='capStart' onClick='capture()'&gt;Capture&lt;/button&gt;
 *    &lt;button type='button' id='upStart' onClick='upload( {dir:'≪値≫'} )'&gt;Upload&lt;/button&gt;&lt;br /&gt;
 *    &lt;div id='videotop' style='display:flex;' &gt;
 *        &lt;video id='player' autoplay style='background-color: black;position: absolute;z-index: 1;'&gt;&lt;/video&gt;
 *        &lt;canvas id='snapshot' style='visibility:hidden;z-index: 2; '&gt;&lt;/canvas&gt;
 *    &lt;/div&gt;
 *
 * script は、1画面1つしかカメラは使います。
 * これらは、使用する画面に、組み込んでください。
 * &lt;script src="{&#064;SYS.JSP}/option/videocamera.js"&gt;&lt;!-- --&gt;&lt;/script&gt;
 *
 * @og.rev 7.4.2.1 (2021/05/21) 新規作成
 * @og.group データ編集
 *
 * @version  7.4
 * @author   Kazuhiko Hasegawa
 * @since    JDK11.0,
 */
public class Editor_SNAP extends AbstractEditor {
	/** このプログラムのVERSION文字列を設定します。	{@value} */
	private static final String VERSION = "7.4.2.1 (2021/05/21)" ;

//	// 7.4.2.2 (2021/05/28) ｼｽﾃﾑ定数のJSPを使用します。(※ SYS.JSP + SYS.IMAGE_DIR)
//	private static final String JSP_OPT =  HybsSystem.sys( "JSP" ) + "/option/" ;

//	private static final String JS_SRC = "<script src='" + JSP_OPT + "videocamera.js' ><!-- --></script>" ;

	private static final String BASE_HTML1 =
										"<button type='button' id='vidStart' onClick='videoStart()'>Video Start</button>"
								+ CR +	"<button type='button' id='capStart' onClick='capture()'>Capture</button>"
								+ CR +	"<button type='button' id='upStart' onClick='upload({dir:\"" ;

	private static final String BASE_HTML2 = "\"})'>Upload</button><br />"
								+ CR +	"<div id='videotop' style='display:flex;' >"
								+ CR +	"<video id='player' autoplay style='background-color: black;position: absolute;z-index: 1;'></video>"
								+ CR +	"<canvas id='snapshot' style='visibility:hidden;z-index: 2; '></canvas>"
								+ CR +	"</div>" ;

	/**
	 * デフォルトコンストラクター。
	 * このコンストラクターで、基本オブジェクトを作成します。
	 *
	 * @og.rev 7.4.2.1 (2021/05/21) 新規作成
	 *
	 */
	public Editor_SNAP() { super(); }		// これも、自動的に呼ばれるが、空のメソッドを作成すると警告されるので、明示的にしておきます。

	/**
	 * コンストラクター。
	 *
	 * @og.rev 7.4.2.1 (2021/05/21) 新規作成
	 *
	 * @param	clm	DBColumnオブジェクト
	 */
	protected Editor_SNAP( final DBColumn clm ) {
		super( clm );

//		// Attributesの連結記述
//		attributes = new Attributes()
//					.set( clm.getEditorAttributes() )
//					.add( "class"		, clm.getDbType() );
//
//		tagBuffer.add( XHTMLTag.textareaAttri( attributes ) );
	}

	/**
	 * 各オブジェクトから自分のインスタンスを返します。
	 * 自分自身をキャッシュするのか、新たに作成するのかは、各サブクラスの実装に
	 * まかされます。
	 *
	 * @og.rev 7.4.2.1 (2021/05/21) 新規作成
	 *
	 * @param	clm	DBColumnオブジェクト
	 *
	 * @return	CellEditorオブジェクト
	 * @og.rtnNotNull
	 */
	public CellEditor newInstance( final DBColumn clm ) {
		return new Editor_SNAP( clm );
	}

	/**
	 * データの編集用文字列を返します。
	 *
	 * @og.rev 7.4.2.1 (2021/05/21) 新規作成
	 *
	 * @param   value 入力値
	 *
	 * @return  データの編集用文字列
	 * @og.rtnNotNull
	 */
	@Override
	public String getValue( final String value ) {
		// TagBufferの連結記述
//		return BASE_HTML.replaceAll( "≪値≫" , value );
		return BASE_HTML1 + value + BASE_HTML2 ;
	}

	/**
	 * name属性を変えた、データ表示/編集用のHTML文字列を作成します。
	 * テーブル上の name に 行番号を付加して、名前_行番号 で登録するキーを作成し,
	 * リクエスト情報を１つ毎のフィールドで処理できます。
	 *
	 * @og.rev 7.4.2.1 (2021/05/21) 新規作成
	 *
	 * @param   row   行番号
	 * @param   value 入力値
	 *
	 * @return  データ表示/編集用の文字列
	 * @og.rtnNotNull
	 */
	@Override
	public String getValue( final int row,final String value ) {
//		final String newName = name + HybsSystem.JOINT_STRING + row;		// newName は未使用

//		return BASE_HTML.replaceAll( "≪値≫" , value );
		return BASE_HTML1 + value + BASE_HTML2 ;
	}
}
