/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.opengion.fukurou.model.EventReader;
import org.opengion.fukurou.model.ExcelStyleFormat;
import org.opengion.fukurou.model.POIUtil;
import org.opengion.fukurou.model.TableModelHelper;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;
import org.opengion.fukurou.system.ThrowUtil;
import org.opengion.fukurou.xml.HybsErrorListener;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class EventReader_XLSX
implements EventReader {
    private static final String VERSION = "7.2.9.4 (2020/11/20)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventReader(File file, TableModelHelper tableModelHelper) {
        OPCPackage oPCPackage = null;
        XMLReader xMLReader = null;
        try {
            tableModelHelper.startFile(file);
            oPCPackage = OPCPackage.open((File)file);
            XSSFReader xSSFReader = new XSSFReader(oPCPackage);
            xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            xMLReader.setErrorHandler(new HybsErrorListener());
            List<SheetObj> list = EventReader_XLSX.getSheetList(xSSFReader, xMLReader);
            tableModelHelper.sheetSize(list.size());
            SharedStringsTable sharedStringsTable = xSSFReader.getSharedStringsTable();
            StylesTable stylesTable = xSSFReader.getStylesTable();
            SheetHandler sheetHandler = new SheetHandler(stylesTable, sharedStringsTable, tableModelHelper);
            xMLReader.setContentHandler(sheetHandler);
            InputStream inputStream = null;
            for (int i = 0; i < list.size(); ++i) {
                SheetObj sheetObj = list.get(i);
                if (tableModelHelper.startSheet(sheetObj.getName(), i)) {
                    try {
                        inputStream = xSSFReader.getSheet(sheetObj.getRid());
                        xMLReader.parse(new InputSource(inputStream));
                    }
                    catch (Throwable throwable) {
                        Closer.ioClose(inputStream);
                        throw throwable;
                    }
                    Closer.ioClose(inputStream);
                }
                tableModelHelper.endSheet(i);
            }
        }
        catch (OpenXML4JException openXML4JException) {
            String string = ".xlsx\u306e\u30d5\u30a1\u30a4\u30eb\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 filename=" + file + HybsConst.CR + openXML4JException.getMessage();
            throw new OgRuntimeException(string, openXML4JException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "\u8981\u6c42\u3055\u308c\u305f\u69cb\u6210\u3092\u6e80\u305f\u3059\u30d1\u30fc\u30b5\u30fc\u3092\u751f\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002 filename=" + file + HybsConst.CR + parserConfigurationException.getMessage();
            throw new OgRuntimeException(string, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string = "SAX \u306e\u4e00\u822c\u7684\u306a\u30a8\u30e9\u30fc\u307e\u305f\u306f\u8b66\u544a\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002 filename=" + file + HybsConst.CR + xMLReader == null ? sAXException.getMessage() : xMLReader.getErrorHandler().toString();
            throw new OgRuntimeException(string, sAXException);
        }
        catch (IOException iOException) {
            String string = ".xlsx\u306e\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u53d6\u308a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002 filename=" + file + HybsConst.CR + iOException.getMessage();
            throw new OgRuntimeException(string, iOException);
        }
        finally {
            if (oPCPackage != null) {
                oPCPackage.revert();
            }
            tableModelHelper.endFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SheetObj> getSheetList(XSSFReader xSSFReader, XMLReader xMLReader) throws SAXException, IOException, InvalidFormatException {
        final ArrayList<SheetObj> arrayList = new ArrayList<SheetObj>();
        xMLReader.setContentHandler(new DefaultHandler(){

            @Override
            public void startElement(String string, String string2, String string3, Attributes attributes) {
                if ("sheet".equals(string3)) {
                    String string4 = attributes.getValue("name");
                    String string5 = attributes.getValue("r:id");
                    arrayList.add(new SheetObj(string4, string5));
                }
            }
        });
        InputStream inputStream = null;
        try {
            inputStream = xSSFReader.getWorkbookData();
            xMLReader.parse(new InputSource(inputStream));
        }
        finally {
            Closer.ioClose(inputStream);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java org.opengion.fukurou.model.EventReader_XLSX \u5165\u529b\u30d5\u30a1\u30a4\u30eb\u540d");
            return;
        }
        File file = new File(stringArray[0]);
        EventReader_XLSX eventReader_XLSX = new EventReader_XLSX();
        eventReader_XLSX.eventReader(file, new TableModelHelper(){

            @Override
            public boolean startSheet(String string, int n) {
                System.out.println("S[" + n + "]=" + string);
                return super.startSheet(string, n);
            }

            @Override
            public boolean value(String string, int n, int n2) {
                System.out.println("R[" + n + "],C[" + n2 + "]=" + string);
                return super.value(string, n, n2);
            }
        });
    }

    private static final class SheetHandler
    extends DefaultHandler {
        private final SharedStringsTable sst;
        private final TableModelHelper helper;
        private final ExcelStyleFormat format;
        private String lastContents = "";
        private XSSFDataType nextDataType = XSSFDataType.NUMBER;
        private String cellStyleStr;
        private int rowNo = -1;
        private int colNo = -1;
        private boolean isRowSkip;

        public SheetHandler(StylesTable stylesTable, SharedStringsTable sharedStringsTable, TableModelHelper tableModelHelper) {
            this.sst = sharedStringsTable;
            this.helper = tableModelHelper;
            this.format = new ExcelStyleFormat(stylesTable);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ("row".equals(string3)) {
                this.rowNo = Integer.parseInt(attributes.getValue("r")) - 1;
                this.isRowSkip = false;
            } else {
                if (this.isRowSkip) {
                    return;
                }
                if ("c".equals(string3)) {
                    String string4 = attributes.getValue("r");
                    int[] nArray = POIUtil.kigo2rowCol(string4);
                    this.colNo = nArray[1];
                    this.nextDataType = XSSFDataType.NUMBER;
                    this.cellStyleStr = attributes.getValue("s");
                    String string5 = attributes.getValue("t");
                    if ("b".equals(string5)) {
                        this.nextDataType = XSSFDataType.BOOL;
                    } else if ("e".equals(string5)) {
                        this.nextDataType = XSSFDataType.ERROR;
                    } else if ("inlineStr".equals(string5)) {
                        this.nextDataType = XSSFDataType.INLINESTR;
                    } else if ("s".equals(string5)) {
                        this.nextDataType = XSSFDataType.SSTINDEX;
                    } else if ("str".equals(string5)) {
                        this.nextDataType = XSSFDataType.FORMULA;
                    }
                }
            }
            this.lastContents = "";
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            this.isRowSkip = this.helper.isSkip(this.rowNo);
            if (this.isRowSkip) {
                return;
            }
            Object object = null;
            if ("v".equals(string3)) {
                switch (this.nextDataType) {
                    case BOOL: {
                        object = this.lastContents.isEmpty() || this.lastContents.charAt(0) == '0' ? "FALSE" : "TRUE";
                        break;
                    }
                    case ERROR: {
                        object = "\"ERROR:" + this.lastContents + "\"";
                        break;
                    }
                    case FORMULA: {
                        object = "\"" + this.lastContents + "\"";
                        break;
                    }
                    case INLINESTR: {
                        object = new XSSFRichTextString(this.lastContents).toString();
                        break;
                    }
                    case SSTINDEX: {
                        String string4 = this.lastContents;
                        try {
                            int n = Integer.parseInt(string4);
                            object = this.sst.getItemAt(n).getString();
                        }
                        catch (NumberFormatException numberFormatException) {
                            String string5 = ThrowUtil.ogThrowMsg("Failed to parse SST index [" + string4 + "]: ", numberFormatException);
                            System.out.println(string5);
                        }
                        break;
                    }
                    case NUMBER: {
                        object = this.format.getNumberValue(this.cellStyleStr, this.lastContents);
                        break;
                    }
                    default: {
                        object = "(TODO: Unexpected type: " + this.nextDataType + ")";
                        break;
                    }
                }
            } else if ("t".equals(string3) && this.nextDataType == XSSFDataType.INLINESTR) {
                object = new XSSFRichTextString(this.lastContents).toString();
            }
            if (object != null) {
                this.helper.value((String)object, this.rowNo, this.colNo);
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (!this.isRowSkip) {
                this.lastContents = this.lastContents + new String(cArray, n, n2);
            }
        }
    }

    private static final class SheetObj {
        private final String name;
        private final String rid;

        public SheetObj(String string, String string2) {
            this.name = string;
            this.rid = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getRid() {
            return this.rid;
        }
    }

    private static enum XSSFDataType {
        BOOL,
        ERROR,
        FORMULA,
        INLINESTR,
        SSTINDEX,
        NUMBER;

    }
}

