/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.system.Closer;
import org.opengion.fukurou.system.HybsConst;
import org.opengion.fukurou.system.OgRuntimeException;

public final class HybsCryptography {
    private final SecretKeySpec sksSpec;
    private static final String CIPHER_TYPE = "Blowfish";
    private static final char[] HEXA_DECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private static final String HYBS_CRYPT_KEY = "2a5a88891d37ae59";

    public HybsCryptography() {
        this(HYBS_CRYPT_KEY);
    }

    public HybsCryptography(String string) {
        String string2 = string == null || string.length() == 0 ? HYBS_CRYPT_KEY : string;
        this.sksSpec = new SecretKeySpec(string2.getBytes(DEFAULT_CHARSET), CIPHER_TYPE);
    }

    public String encrypt(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
            cipher.init(1, this.sksSpec);
            byte[] byArray = cipher.doFinal(string.getBytes(DEFAULT_CHARSET));
            return HybsCryptography.byte2hexa(byArray);
        }
        catch (GeneralSecurityException generalSecurityException) {
            String string2 = "\u6697\u53f7\u5316\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + string + "]" + generalSecurityException.getMessage();
            throw new OgRuntimeException(string2, generalSecurityException);
        }
    }

    public String decrypt(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_TYPE);
            cipher.init(2, this.sksSpec);
            byte[] byArray = HybsCryptography.hexa2byte(string);
            byte[] byArray2 = cipher.doFinal(byArray);
            return new String(byArray2, DEFAULT_CHARSET);
        }
        catch (GeneralSecurityException generalSecurityException) {
            String string2 = "\u5fa9\u53f7\u5316\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + string + "]" + generalSecurityException.getMessage();
            throw new OgRuntimeException(string2, generalSecurityException);
        }
    }

    public static String byte2hexa(byte[] byArray) {
        String string = null;
        if (byArray != null && byArray.length > 0) {
            int n = byArray.length;
            char[] cArray = new char[n * 2];
            for (int i = 0; i < n; ++i) {
                int n2 = (byArray[i] & 0xF0) >> 4;
                int n3 = byArray[i] & 0xF;
                cArray[i * 2] = HEXA_DECIMAL[n2];
                cArray[i * 2 + 1] = HEXA_DECIMAL[n3];
            }
            string = new String(cArray);
        }
        return string;
    }

    public static byte[] hexa2byte(String string) {
        byte[] byArray = null;
        if (string != null) {
            int n = string.length();
            byArray = new byte[n / 2];
            for (int i = 0; i < n / 2; ++i) {
                char c = string.charAt(i * 2);
                int n2 = c < 'a' ? c - 48 : c - 97 + 10;
                c = string.charAt(i * 2 + 1);
                int n3 = c < 'a' ? c - 48 : c - 97 + 10;
                byArray[i] = (byte)(n2 << 4 | n3);
            }
        }
        return byArray;
    }

    public static String getHash(String string, String string2) {
        String string3 = null;
        if (string != null && string2 != null) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string);
                messageDigest.update(string2.getBytes(DEFAULT_CHARSET));
                byte[] byArray = messageDigest.digest();
                string3 = HybsCryptography.byte2hexa(byArray);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                String string4 = "MessageDigest\u3067\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "\uff8a\uff6f\uff7c\uff6d\uff7a\uff70\uff84\uff9e=[" + string + "] , \u5909\u63db\u524d=[" + string2 + "]" + HybsConst.CR + noSuchAlgorithmException.getMessage();
                throw new OgRuntimeException(string4, noSuchAlgorithmException);
            }
        }
        return string3;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHash(String string, FileOperation fileOperation) {
        String string2 = null;
        if (string == null) return string2;
        if (fileOperation == null) return string2;
        InputStream inputStream = null;
        DigestInputStream digestInputStream = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            inputStream = fileOperation.read();
            digestInputStream = new DigestInputStream(inputStream, messageDigest);
            byte[] byArray = new byte[1024];
            while (digestInputStream.read(byArray) > 0) {
            }
            byte[] byArray2 = messageDigest.digest();
            string2 = HybsCryptography.byte2hexa(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                String string3 = "MessageDigest\u3067\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "\uff8a\uff6f\uff7c\uff6d\uff7a\uff70\uff84\uff9e=[" + string + "] , \u5909\u63db\u524d=[" + fileOperation + "]" + HybsConst.CR + noSuchAlgorithmException.getMessage();
                throw new RuntimeException(string3, noSuchAlgorithmException);
                catch (IOException iOException) {
                    String string4 = "\uff8c\uff67\uff72\uff99\u306e\u8aad\u307f\u53d6\u308a\u3092\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + fileOperation + "]" + iOException.getMessage();
                    throw new RuntimeException(string4, iOException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(digestInputStream);
                Closer.ioClose(inputStream);
                throw throwable;
            }
        }
        Closer.ioClose(digestInputStream);
        Closer.ioClose(inputStream);
        return string2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHash(String string, File file) {
        if (file instanceof FileOperation) {
            return HybsCryptography.getHash(string, (FileOperation)file);
        }
        String string2 = null;
        if (string == null) return string2;
        if (file == null) return string2;
        FileInputStream fileInputStream = null;
        FileChannel fileChannel = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            fileInputStream = new FileInputStream(file);
            fileChannel = fileInputStream.getChannel();
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
            messageDigest.update(mappedByteBuffer);
            byte[] byArray = messageDigest.digest();
            string2 = HybsCryptography.byte2hexa(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                String string3 = "MessageDigest\u3067\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + HybsConst.CR + "\uff8a\uff6f\uff7c\uff6d\uff7a\uff70\uff84\uff9e=[" + string + "] , \u5909\u63db\u524d=[" + file + "]" + HybsConst.CR + noSuchAlgorithmException.getMessage();
                throw new OgRuntimeException(string3, noSuchAlgorithmException);
                catch (IOException iOException) {
                    String string4 = "\uff8c\uff67\uff72\uff99\u306e\u8aad\u307f\u53d6\u308a\u3092\u5931\u6557\u3057\u307e\u3057\u305f\u3002[" + file + "]" + iOException.getMessage();
                    throw new OgRuntimeException(string4, iOException);
                }
            }
            catch (Throwable throwable) {
                Closer.ioClose(fileChannel);
                Closer.ioClose(fileInputStream);
                throw throwable;
            }
        }
        Closer.ioClose(fileChannel);
        Closer.ioClose(fileInputStream);
        return string2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("java HybsCryptography KEY TEXT");
            System.out.println("  KEY  : \u79d8\u5bc6\u9375(8 \u306e\u500d\u6570 (32 \u4ee5\u4e0a 448 \u4ee5\u4e0b)\u6587\u5b57)");
            System.out.println("  TEXT : \u5909\u63db\u3059\u308b\u6587\u5b57\u5217");
            return;
        }
        HybsCryptography hybsCryptography = new HybsCryptography(stringArray[0]);
        System.out.println("IN   TEXT : " + stringArray[1]);
        String string = hybsCryptography.encrypt(stringArray[1]);
        System.out.println("HEXA TEXT : " + string);
        String string2 = hybsCryptography.decrypt(string);
        System.out.println("OUT  DATA : " + string2);
    }
}

