/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.db.DBColumn;
import org.opengion.hayabusa.db.DBTableModel;
import org.opengion.hayabusa.db.DBTableModelUtil;
import org.opengion.hayabusa.servlet.MultipartRequest;
import org.opengion.hayabusa.servlet.UploadedFile;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class FileUploadTag
extends CommonTagSupport {
    private static final String VERSION = "8.1.2.0 (2022/03/10)";
    private static final long serialVersionUID = 812020220310L;
    public static final String UPLOAD_FILES = "UPLOAD_FILES";
    private static final String[] NAMES = new String[]{"KEY", "VALUE", "ISFILE"};
    private static final String ENCODE = "UTF-8";
    private static final String HASH_CODE = HybsSystem.sys("FILE_HASH_CODE");
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String filename;
    private int maxPostSize = 0x1E00000;
    private String tableId = "h_tblmdl";
    private String columns;
    private String useBackup;
    private boolean useLocal;

    @Override
    public int doEndTag() {
        this.debugPrint();
        this.startQueryTransaction(this.tableId);
        HttpServletRequest httpServletRequest = (HttpServletRequest)this.getRequest();
        try {
            DBTableModel dBTableModel;
            String string = HybsSystem.url2dir(this.fileURL);
            MultipartRequest multipartRequest = new MultipartRequest(httpServletRequest, string, this.maxPostSize, ENCODE, this.filename, this.useBackup, this.fileURL, this.useLocal);
            DBTableModel dBTableModel2 = dBTableModel = this.columns == null ? this.makeDBTable(multipartRequest) : this.makeDBTableFromClms(multipartRequest);
            if (!this.commitTableObject(this.tableId, dBTableModel)) {
                this.jspPrint("FileUploadTag " + this.getResource().getLabel("ERR0041", new String[0]));
                return 5;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = this.getResource().getLabel("ERR0043", new String[0]) + "[" + this.fileURL + "]" + CR + illegalArgumentException.getMessage();
            throw new HybsSystemException(string, illegalArgumentException);
        }
        catch (IOException iOException) {
            String string = this.getResource().getLabel("ERR0044", new String[0]) + iOException.getMessage() + CR + "(" + this.toString() + CR + "FileURL=" + this.fileURL + ")";
            throw new HybsSystemException(string, iOException);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.maxPostSize = 0x1E00000;
        this.tableId = "h_tblmdl";
        this.filename = null;
        this.columns = null;
        this.useBackup = null;
        this.useLocal = false;
    }

    private DBTableModel makeDBTable(MultipartRequest multipartRequest) {
        Object object;
        String string;
        Object object2;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        dBTableModel.init(NAMES.length);
        for (int i = 0; i < NAMES.length; ++i) {
            object2 = this.getDBColumn(NAMES[i]);
            dBTableModel.setDBColumn(i, (DBColumn)object2);
        }
        object2 = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        UploadedFile[] uploadedFileArray = multipartRequest.getUploadedFile();
        for (int i = 0; i < uploadedFileArray.length; ++i) {
            String string2 = uploadedFileArray[i].getName();
            string = uploadedFileArray[i].getUploadFile();
            arrayList.add(string);
            String[] stringArray = new String[]{string2, string, "1"};
            dBTableModel.addColumnValues(stringArray);
            this.setRequestAttribute(string2, string);
            object2.add(string2);
            object = string2 + "_ORG";
            string = uploadedFileArray[i].getOriginalFileName();
            stringArray = new String[]{object, string, "2"};
            dBTableModel.addColumnValues(stringArray);
            this.setRequestAttribute((String)object, string);
        }
        this.setRequestAttribute(UPLOAD_FILES, arrayList);
        String[] stringArray = new String[]{"directory", this.fileURL, "0"};
        dBTableModel.addColumnValues(stringArray);
        this.setRequestAttribute("directory", this.fileURL);
        String[] stringArray2 = multipartRequest.getParameterNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            string = stringArray2[i];
            if ("h_rowSel".equals(string)) {
                this.setRequestAttribute(string, multipartRequest.getIntParameters(string));
                continue;
            }
            object = this.getParamVal(string, multipartRequest);
            stringArray = new String[]{string, object, "0"};
            dBTableModel.addColumnValues(stringArray);
            this.setRequestAttribute(string, object);
            object2.add(string);
        }
        this.setParameterNames(object2.toArray(new String[object2.size()]));
        return dBTableModel;
    }

    private DBTableModel makeDBTableFromClms(MultipartRequest multipartRequest) {
        Object object;
        Object object2;
        Object object3;
        DBTableModel dBTableModel = DBTableModelUtil.newDBTable();
        String[] stringArray = this.columns.split(",");
        dBTableModel.init(stringArray.length);
        String[] stringArray2 = new String[stringArray.length];
        UploadedFile[] uploadedFileArray = multipartRequest.getUploadedFile();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            object3 = this.getDBColumn(string);
            dBTableModel.setDBColumn(i, (DBColumn)object3);
            object2 = this.getParamVal(string, multipartRequest);
            if (object2 == null) {
                for (int j = 0; j < uploadedFileArray.length; ++j) {
                    object = uploadedFileArray[j].getName();
                    if (!string.equalsIgnoreCase((String)object)) continue;
                    object2 = uploadedFileArray[i].getUploadFile();
                    break;
                }
            }
            stringArray2[i] = object2 == null ? "" : object2;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (int i = 0; i < uploadedFileArray.length; ++i) {
            object3 = uploadedFileArray[i].getName();
            object2 = new String[stringArray.length];
            System.arraycopy(stringArray2, 0, object2, 0, ((String[])object2).length);
            String string = uploadedFileArray[i].getUploadFile();
            this.setRequestAttribute((String)object3, string);
            arrayList.add(object3);
            arrayList2.add(string);
            object = (String)object3 + "_ORG";
            String string2 = uploadedFileArray[i].getOriginalFileName();
            this.setRequestAttribute((String)object, string2);
            int n = ((String)object3).lastIndexOf(95);
            if (n > 0) {
                String string3 = ((String)object3).substring(0, n);
                String string4 = ((String)object3).substring(n);
                for (int j = 0; j < stringArray.length; ++j) {
                    String string5 = stringArray[j];
                    String string6 = null;
                    String string7 = null;
                    if (string3.equalsIgnoreCase(string5)) {
                        string7 = string;
                    } else if ((string3 + "_ORG").equalsIgnoreCase(string5)) {
                        string7 = string2;
                    } else if ((string3 + "_NEW").equalsIgnoreCase(string5)) {
                        string6 = (String)object3 + "_NEW";
                        string7 = multipartRequest.getParameter(string6);
                    } else if ((string3 + "_PFX").equalsIgnoreCase(string5)) {
                        string6 = (String)object3 + "_PFX";
                        string7 = multipartRequest.getParameter(string6);
                    } else if ((string3 + "_SFX").equalsIgnoreCase(string5)) {
                        string6 = (String)object3 + "_SFX";
                        string7 = multipartRequest.getParameter(string6);
                    } else if ((string3 + "_HASH").equalsIgnoreCase(string5)) {
                        string6 = (String)object3 + "_HASH";
                        File file = uploadedFileArray[i].getFile(this.useLocal);
                        string7 = HybsCryptography.getHash((String)HASH_CODE, (File)file);
                    } else {
                        string6 = stringArray[j] + string4;
                        string7 = this.getParamVal(string6, multipartRequest);
                    }
                    if (string7 == null) continue;
                    object2[j] = string7;
                }
            }
            dBTableModel.addColumnValues((String[])object2);
        }
        this.setRequestAttribute(UPLOAD_FILES, arrayList2);
        this.setRequestAttribute("directory", this.fileURL);
        String[] stringArray3 = multipartRequest.getParameterNames();
        for (int i = 0; i < stringArray3.length; ++i) {
            object2 = stringArray3[i];
            if ("h_rowSel".equals(object2)) {
                this.setRequestAttribute((String)object2, multipartRequest.getIntParameters((String)object2));
                continue;
            }
            String string = this.getParamVal((String)object2, multipartRequest);
            this.setRequestAttribute((String)object2, string);
            arrayList.add(object2);
        }
        this.setParameterNames(arrayList.toArray(new String[arrayList.size()]));
        return dBTableModel;
    }

    private String getParamVal(String string, MultipartRequest multipartRequest) {
        String string2 = multipartRequest.getParameter(string);
        if ("0".equals(string2)) {
            String[] stringArray;
            for (String string3 : stringArray = multipartRequest.getParameters(string)) {
                if (!"1".equals(string3)) continue;
                string2 = "1";
                break;
            }
        }
        return string2;
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 == null) {
            this.chckReqParam(string, "fileURL");
        } else {
            this.fileURL = StringUtil.urlAppend((CharSequence)this.fileURL, (CharSequence[])new CharSequence[]{string2});
        }
    }

    public void setMaxPostSize(String string) {
        this.maxPostSize = StringUtil.nval((String)this.getRequestParameter(string), (int)this.maxPostSize);
        this.chckReqParam(string, "maxPostSize");
    }

    public void setTableId(String string) {
        this.tableId = StringUtil.nval((String)this.getRequestParameter(string), (String)this.tableId);
        this.chckReqParam(string, "tableId");
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getReservedParameter(string), null);
    }

    public void setColumns(String string) {
        this.columns = StringUtil.nval((String)this.getRequestParameter(string), (String)this.columns);
        this.chckReqParam(string, "columns");
    }

    public void setUseBackup(String string) {
        this.useBackup = StringUtil.nval((String)this.getRequestParameter(string), (String)this.useBackup);
        if (this.useBackup != null && "true/false/rename".indexOf(this.useBackup.toLowerCase(Locale.JAPAN)) < 0) {
            String string2 = "useBackup \u5c5e\u6027\u306f\uff64[true/false/rename] \u304b\u3089\uff64\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044\u3002 useBackup=[" + this.useBackup + "]" + CR;
            throw new HybsSystemException(string2);
        }
        this.chckReqParam(string, "useBackup");
    }

    private void chckReqParam(String string, String string2) {
        if (this.isNull() && string != null && string.contains("{@")) {
            String string3 = "upload \u3067\u306f\uff64enctype=\"multipart/form-data\" \u306e\u305f\u3081\uff64{@XXXX}\u5f62\u5f0f\u306e\uff8a\uff9f\uff97\uff92\uff70\uff80\u304c\u4f7f\u3048\u307e\u305b\u3093\u3002" + CR + "    " + string2 + "=[" + string + "]";
            throw new HybsSystemException(string3);
        }
    }

    @Override
    protected String getTagName() {
        return "upload";
    }

    public void setUseLocal(String string) {
        this.useLocal = StringUtil.nval((String)this.getRequestParameter(string), (boolean)this.useLocal);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("names", (Object[])NAMES).println("ENCODE", (Object)ENCODE).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).println("maxPostSize", (Object)this.maxPostSize).println("tableId", (Object)this.tableId).println("columns", (Object)this.columns).println("useBackup", (Object)this.useBackup).println("Other...", (Object)this.getAttributes().getAttribute()).fixForm().toString();
    }
}

