/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.firebirdsql.gds.ISCConstants;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class ParameterBufferHelper {
    private static final Logger log;
    private static final DpbParameterType UNKNOWN_DPB_TYPE;
    public static final String DPB_PREFIX = "isc_dpb_";
    public static final String TPB_PREFIX = "isc_tpb_";
    public static final String ISC_DPB_TYPES_RESOURCE = "isc_dpb_types.properties";
    private static final Map<String, Integer> dpbTypes;
    private static final Map<String, DpbParameterType> dpbParameterTypes;
    private static final Map<String, Integer> tpbTypes;

    public static Integer getDpbKey(String name) {
        return dpbTypes.get(name);
    }

    public static DpbParameterType getDpbParameterType(String name) {
        Integer dpbKey;
        DpbParameterType dpbParameterType = dpbParameterTypes.get(name);
        if (dpbParameterType == null && (dpbKey = ParameterBufferHelper.getDpbKey(name)) != null) {
            Object canonicalName = name.startsWith(DPB_PREFIX) ? name : DPB_PREFIX + name;
            dpbParameterType = new DpbParameterType((String)canonicalName, dpbKey, DpbValueType.TYPE_UNKNOWN);
        }
        return dpbParameterType;
    }

    public static Map<String, Integer> getDpbMap() {
        return dpbTypes;
    }

    @Deprecated
    public static Object parseDpbString(String name, Object value) {
        DpbParameterType type = dpbParameterTypes.get(name);
        if (type == null) {
            type = UNKNOWN_DPB_TYPE;
        }
        return type.parseDpbString(value);
    }

    public static Object parseDpbString(String name, String value) {
        DpbParameterType type = dpbParameterTypes.get(name);
        if (type == null) {
            type = UNKNOWN_DPB_TYPE;
        }
        return type.parseDpbString(value);
    }

    public static Integer getTpbParam(String name) {
        return tpbTypes.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String resource) throws IOException {
        ClassLoader cl = ParameterBufferHelper.class.getClassLoader();
        InputStream in = cl == null ? ClassLoader.getSystemResourceAsStream(resource) : cl.getResourceAsStream(resource);
        if (in == null) {
            throw new IOException("Unable to load resource file " + resource);
        }
        try {
            Properties props = new Properties();
            props.load(in);
            Properties properties = props;
            return properties;
        }
        finally {
            in.close();
        }
    }

    private static Map<String, DpbParameterType> loadDpbParameterTypes() {
        Properties props;
        try {
            props = ParameterBufferHelper.loadProperties(ISC_DPB_TYPES_RESOURCE);
        }
        catch (IOException ex) {
            log.error("Could not load isc_dpb_types.properties", ex);
            return Collections.emptyMap();
        }
        HashMap<String, DpbParameterType> tempDpbParameterTypes = new HashMap<String, DpbParameterType>(128);
        block14: for (Map.Entry<Object, Object> entry : props.entrySet()) {
            DpbValueType typeValue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            int hashIndex = value.indexOf(35);
            if (hashIndex != -1) {
                value = value.substring(0, hashIndex).trim();
            }
            switch (value) {
                case "boolean": {
                    typeValue = DpbValueType.TYPE_BOOLEAN;
                    break;
                }
                case "byte": {
                    typeValue = DpbValueType.TYPE_BYTE;
                    break;
                }
                case "int": {
                    typeValue = DpbValueType.TYPE_INT;
                    break;
                }
                case "string": {
                    typeValue = DpbValueType.TYPE_STRING;
                    break;
                }
                default: {
                    continue block14;
                }
            }
            Integer dpbKey = dpbTypes.get(key);
            DpbParameterType dpbParameterType = new DpbParameterType(key, dpbKey, typeValue);
            tempDpbParameterTypes.put(key, dpbParameterType);
            tempDpbParameterTypes.put(dpbParameterType.getShortName(), dpbParameterType);
        }
        return tempDpbParameterTypes;
    }

    static {
        Field[] fields;
        log = LoggerFactory.getLogger(ParameterBufferHelper.class);
        UNKNOWN_DPB_TYPE = new DpbParameterType(null, null, DpbValueType.TYPE_UNKNOWN);
        HashMap<String, Integer> tempDpbTypes = new HashMap<String, Integer>(512);
        HashMap<String, Integer> tempTpbTypes = new HashMap<String, Integer>(64);
        for (Field field : fields = ISCConstants.class.getFields()) {
            Integer value;
            String name = field.getName();
            if (!name.startsWith(DPB_PREFIX) && !name.startsWith(TPB_PREFIX) || !field.getType().equals(Integer.TYPE)) continue;
            try {
                int tempValue = field.getInt(null);
                if (tempValue > 148) continue;
                value = tempValue;
            }
            catch (IllegalAccessException iaex) {
                continue;
            }
            if (name.startsWith(DPB_PREFIX)) {
                tempDpbTypes.put(name.substring(DPB_PREFIX.length()), value);
                tempDpbTypes.put(name, value);
                continue;
            }
            if (!name.startsWith(TPB_PREFIX)) continue;
            tempTpbTypes.put(name.substring(TPB_PREFIX.length()), value);
            tempTpbTypes.put(name, value);
        }
        dpbTypes = Collections.unmodifiableMap(tempDpbTypes);
        tpbTypes = Collections.unmodifiableMap(tempTpbTypes);
        dpbParameterTypes = Collections.unmodifiableMap(ParameterBufferHelper.loadDpbParameterTypes());
    }

    public static class DpbParameterType {
        private final String name;
        private final String shortName;
        private final Integer dpbKey;
        private final DpbValueType type;

        public DpbParameterType(String name, Integer dpbKey, DpbValueType type) {
            this.name = name;
            this.shortName = name != null ? name.substring(ParameterBufferHelper.DPB_PREFIX.length()) : null;
            this.dpbKey = dpbKey;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public String getShortName() {
            return this.shortName;
        }

        public Integer getDpbKey() {
            return this.dpbKey;
        }

        public DpbValueType getType() {
            return this.type;
        }

        @Deprecated
        public Object parseDpbString(Object value) {
            if (value == null || value instanceof String) {
                return this.type.parseDpbString((String)value);
            }
            if (value instanceof Boolean || value instanceof Byte || value instanceof Integer) {
                return value;
            }
            throw new ClassCastException(value.getClass().getName());
        }

        public Object parseDpbString(String value) {
            return this.type.parseDpbString(value);
        }
    }

    public static enum DpbValueType {
        TYPE_UNKNOWN{

            @Override
            public Object parseDpbString(String value) {
                if (value == null || "".equals(value)) {
                    return Boolean.TRUE;
                }
                try {
                    int intValue = Integer.parseInt(value);
                    if (intValue < 256) {
                        return (byte)intValue;
                    }
                    return intValue;
                }
                catch (NumberFormatException nfex) {
                    return value;
                }
            }
        }
        ,
        TYPE_BOOLEAN{

            @Override
            public Object parseDpbString(String value) {
                return "".equals(value) ? Boolean.TRUE : Boolean.valueOf(value);
            }
        }
        ,
        TYPE_BYTE{

            @Override
            public Object parseDpbString(String value) {
                return Byte.valueOf(value);
            }
        }
        ,
        TYPE_INT{

            @Override
            public Object parseDpbString(String value) {
                return Integer.valueOf(value);
            }
        }
        ,
        TYPE_STRING{

            @Override
            public Object parseDpbString(String value) {
                return value;
            }
        };


        public abstract Object parseDpbString(String var1);
    }
}

