/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version15;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.impl.wire.XdrInputStream;
import org.firebirdsql.gds.impl.wire.XdrOutputStream;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.dbcrypt.DbCryptData;
import org.firebirdsql.gds.ng.wire.WireConnection;
import org.firebirdsql.gds.ng.wire.version13.V13WireOperations;

public class V15WireOperations
extends V13WireOperations {
    public V15WireOperations(WireConnection<?, ?> connection, WarningMessageCallback defaultWarningMessageCallback, Object syncObject) {
        super(connection, defaultWarningMessageCallback, syncObject);
    }

    @Override
    protected DbCryptData readCryptKeyCallback() throws IOException, SQLException {
        XdrInputStream xdrIn = this.getXdrIn();
        byte[] pluginData = xdrIn.readBuffer();
        int replySize = xdrIn.readInt();
        try {
            return new DbCryptData(pluginData, replySize);
        }
        catch (RuntimeException e) {
            throw new FbExceptionBuilder().nonTransientConnectionException(337248285).cause(e).toSQLException();
        }
    }

    @Override
    protected void writeCryptKeyCallback(DbCryptData clientPluginResponse) throws SQLException, IOException {
        XdrOutputStream xdrOut = this.getXdrOut();
        xdrOut.writeInt(97);
        xdrOut.writeBuffer(clientPluginResponse.getPluginData());
        xdrOut.writeInt(clientPluginResponse.getReplySize());
        xdrOut.flush();
    }
}

