/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.escape;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.firebirdsql.jdbc.escape.FBSQLParseException;
import org.firebirdsql.jdbc.escape.SQLFunction;

final class ConvertFunction
implements SQLFunction {
    private static final Pattern TYPE_PATTERN = Pattern.compile("(?:SQL_)?(\\w+)(?:\\s*(\\([^)]*\\)))?", 2);

    ConvertFunction() {
    }

    @Override
    public String apply(String ... parameters) throws FBSQLParseException {
        if (parameters.length != 2) {
            throw new FBSQLParseException("Expected 2 parameters for CONVERT, received " + parameters.length);
        }
        String value = parameters[0];
        String sqlType = parameters[1];
        Matcher typeMatcher = TYPE_PATTERN.matcher(sqlType);
        if (!typeMatcher.matches()) {
            return this.renderCast(value, sqlType);
        }
        return this.renderCast(value, typeMatcher);
    }

    private String renderCast(String value, String sqlType) {
        return "CAST(" + value + " AS " + sqlType + ")";
    }

    private String renderCast(String value, Matcher typeMatcher) {
        String dataType = typeMatcher.group(1).toUpperCase();
        Object parameters = typeMatcher.group(2);
        switch (dataType) {
            case "TINYINT": {
                dataType = "SMALLINT";
                break;
            }
            case "DOUBLE": {
                dataType = "DOUBLE PRECISION";
                break;
            }
            case "CHAR": 
            case "NCHAR": {
                if (parameters != null) break;
                parameters = "(50)";
                break;
            }
            case "VARCHAR": 
            case "NVARCHAR": {
                if (parameters != null) break;
                if (!"?".equals(value)) {
                    return "TRIM(TRAILING FROM " + value + ")";
                }
                parameters = "(50)";
                break;
            }
            case "BINARY": {
                if (parameters == null) {
                    dataType = "CHAR";
                    parameters = "(50) CHARACTER SET OCTETS";
                    break;
                }
                dataType = "CHAR";
                parameters = (String)parameters + " CHARACTER SET OCTETS";
                break;
            }
            case "VARBINARY": {
                if (parameters == null) {
                    dataType = "VARCHAR";
                    parameters = "(50) CHARACTER SET OCTETS";
                    break;
                }
                dataType = "VARCHAR";
                parameters = (String)parameters + " CHARACTER SET OCTETS";
                break;
            }
            case "LONGVARCHAR": 
            case "LONGNVARCHAR": 
            case "CLOB": 
            case "NCLOB": {
                dataType = "BLOB SUB_TYPE TEXT";
                parameters = null;
                break;
            }
            case "LONGVARBINARY": 
            case "BLOB": {
                dataType = "BLOB SUB_TYPE BINARY";
                parameters = null;
                break;
            }
            case "TIME_WITH_TIMEZONE": 
            case "TIME_WITH_TIME_ZONE": {
                dataType = "TIME WITH TIME ZONE";
                parameters = null;
                break;
            }
            case "TIMESTAMP_WITH_TIMEZONE": 
            case "TIMESTAMP_WITH_TIME_ZONE": {
                dataType = "TIMESTAMP WITH TIME ZONE";
                parameters = null;
            }
        }
        return this.renderCast(value, (String)(parameters == null ? dataType : dataType + (String)parameters));
    }
}

