/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.util.Arrays;

public final class PageSizeConstants {
    public static final int SIZE_1K = 1024;
    public static final int SIZE_2K = 2048;
    public static final int SIZE_4K = 4096;
    public static final int SIZE_8K = 8192;
    public static final int SIZE_16K = 16384;
    public static final int SIZE_32K = 32768;
    private static final int[] ALLOWED_PAGE_SIZES = new int[]{1024, 2048, 4096, 8192, 16384, 32768};

    private PageSizeConstants() {
    }

    public static int requireValidPageSize(int pageSize) {
        if (Arrays.binarySearch(ALLOWED_PAGE_SIZES, pageSize) < 0) {
            throw new IllegalArgumentException("Page size must be one of " + Arrays.toString(ALLOWED_PAGE_SIZES));
        }
        return pageSize;
    }
}

