/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.taglib;

import java.util.Locale;
import org.opengion.fukurou.util.Attributes;
import org.opengion.fukurou.util.QrcodeImage;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.fukurou.util.ToString;
import org.opengion.fukurou.util.XHTMLTag;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;
import org.opengion.hayabusa.taglib.CommonTagSupport;

public class QRcodeTag
extends CommonTagSupport {
    private static final String VERSION = "7.2.3.0 (2020/04/10)";
    private static final long serialVersionUID = 723020200410L;
    private static final int MAX_ALT_SIZE = 50;
    private String value;
    private int version = 5;
    private QrcodeImage.EncMode encMode = QrcodeImage.EncMode.DEF;
    private QrcodeImage.ErrCrct errCrct = QrcodeImage.ErrCrct.DEF;
    private String imgType = "PNG";
    private int pixel = 3;
    private String fileURL = HybsSystem.sys("FILE_URL");
    private String filename = "rqcode";
    private String textEncode;

    @Override
    public int doStartTag() {
        if (this.useTag() && (this.value == null || this.value.length() <= 0)) {
            return 2;
        }
        return 0;
    }

    @Override
    public int doAfterBody() {
        this.value = this.getBodyString();
        return 0;
    }

    @Override
    public int doEndTag() {
        this.debugPrint();
        if (this.useTag()) {
            Object object;
            String string;
            if (this.filename.indexOf(46) < 0) {
                this.filename = this.filename + "." + this.imgType.toLowerCase(Locale.JAPAN);
            }
            try {
                string = HybsSystem.url2dir(this.fileURL, this.filename);
                object = new QrcodeImage();
                object.init(this.value, string, this.version, this.encMode, this.errCrct, this.imgType, this.pixel, this.textEncode);
                object.saveImage();
            }
            catch (Throwable throwable) {
                String string2 = "QR\u30b3\u30fc\u30c9\u304c\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" + CR + "\u6307\u5b9a\u306e\u30d1\u30e9\u30e1\u30fc\u30bf\u304c\u6b63\u3057\u3044\u304b\u3069\u3046\u304b\u3054\u78ba\u8a8d\u304f\u3060\u3055\u3044\u3002" + CR + "  version    = [" + this.version + "] \u30d0\u30fc\u30b8\u30e7\u30f3 (2\u304b\u308940\u306e\u6574\u6570)" + CR + "  encodeMode = [" + this.encMode + "] \u30a8\u30f3\u30b3\u30fc\u30c9\u30e2\u30fc\u30c9('N':\u6570\u5b57 'A':\u82f1\u6570\u5b57'B':byte)" + CR + "  errCorrect = [" + this.errCrct + "] \u30a8\u30e9\u30fc\u8a02\u6b63\u30ec\u30d9\u30eb ('L','M','Q','H')" + CR + "  imageType  = [" + this.imgType + "] \u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u5f62\u5f0f(PNG/JPEG)" + CR + "  pixel      = [" + this.pixel + "] \uff11\u30bb\u30eb\u8fba\u308a\u306e\u5857\u308a\u3064\u3076\u3057\u30d4\u30af\u30bb\u30eb";
                throw new HybsSystemException(string2, throwable);
            }
            this.filename = this.filename + "?val=" + System.currentTimeMillis();
            string = StringUtil.urlAppend((CharSequence)this.getContextPath(), (CharSequence[])new CharSequence[]{this.fileURL, this.filename});
            object = this.value.substring(0, Math.min(this.value.length(), 50));
            String string3 = XHTMLTag.img((Attributes)new Attributes().set("src", string).set("alt", (String)object).set("title", (String)object));
            this.jspPrint(string3);
        }
        return 6;
    }

    @Override
    protected void release2() {
        super.release2();
        this.value = null;
        this.version = 5;
        this.encMode = QrcodeImage.EncMode.DEF;
        this.errCrct = QrcodeImage.ErrCrct.DEF;
        this.imgType = "PNG";
        this.pixel = 3;
        this.fileURL = HybsSystem.sys("FILE_URL");
        this.filename = "rqcode";
        this.textEncode = null;
    }

    public void setValue(String string) {
        this.value = StringUtil.nval((String)this.getRequestParameter(string), (String)this.value);
    }

    public void setVersion(String string) {
        this.version = StringUtil.nval((String)this.getRequestParameter(string), (int)this.version);
    }

    public void setEncodeMode(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.encMode = QrcodeImage.EncMode.get((char)string2.charAt(0));
        }
    }

    public void setErrCorrect(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.errCrct = QrcodeImage.ErrCrct.get((char)string2.charAt(0));
        }
    }

    public void setImageType(String string) {
        this.imgType = StringUtil.nval((String)this.getRequestParameter(string), (String)this.imgType);
    }

    public void setPixel(String string) {
        this.pixel = StringUtil.nval((String)this.getRequestParameter(string), (int)this.pixel);
    }

    public void setFileURL(String string) {
        String string2 = StringUtil.nval((String)this.getRequestParameter(string), null);
        if (string2 != null) {
            this.fileURL = StringUtil.urlAppend((CharSequence)this.fileURL, (CharSequence[])new CharSequence[]{string2});
        }
    }

    public void setFilename(String string) {
        this.filename = StringUtil.nval((String)this.getRequestParameter(string), (String)this.filename);
    }

    public void setTextEncode(String string) {
        this.textEncode = StringUtil.nval((String)this.getRequestParameter(string), (String)this.textEncode);
    }

    @Override
    public String toString() {
        return ToString.title((String)((Object)((Object)this)).getClass().getName()).println("VERSION", (Object)VERSION).println("value", (Object)this.value).println("version", (Object)this.version).println("encMode", (Object)this.encMode).println("errCrct", (Object)this.errCrct).println("imgType", (Object)this.imgType).println("pixel", (Object)this.pixel).println("fileURL", (Object)this.fileURL).println("filename", (Object)this.filename).fixForm().toString();
    }
}

