<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />

<!-- ﾁｬｰﾄ情報の取得 -->
<og:query command="NEW">
	SELECT	 ENAME as LABELS
			,SAL  + 2000 as VAL1
			,COMM + 4000 as VAL2
			,case when COMM is null then 'blue' else 'red' end as COL
	FROM BONUS
	union all
	select 'TEST2', 13000.5 VA1, 0.1 , 'green' VAL2 FROM DUAL
	order by 1
</og:query>

<og:columnEditor column="VAL1" className="NUMBER" /> <!-- max,minを数値で出すため -->
<og:value command="SETTBL" action="ALL_MAX_MIN" />

<!-- 全ての属性を設定した形式 -->
<og:jsChart
	chartType		= "{@chartType}"
	labelColumn		= "LABELS"
	height			= "{@height}"
	width			= "{@width}"
	minLabelWidth	= "{@minLabelWidth}"
	title			= "{@chartTitle}"
	xlabel			= "xラベル"
	markValues		= "9000,5000"
	markColors		= "RED,BLUE"
	markLbls		= "基準値,2本目"
	markAdjust		= "-10,10"
	xmarkValues		= "KING"
	xmarkColors		= "GREEN"
	varColumns		= "VAL2,COL"
	debug			= "{@debug}"
>
	<og:jsChartData
		chartColumn		= "VAL1"
		label			= "給料"
		max				= "{@max}"
		min				= "{@min}"
		ylabel			= "yラベル"
		tension			= "0.4"
		pointBGColor	= "COL"
	/>
</og:jsChart>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
