/*
 * Decompiled with CFR 0.152.
 */
package net.black_cow.opennip.opennipcore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.black_cow.opennip.opennipcore.NipObserver;
import net.black_cow.opennip.opennipcore.NipStone;

public class NipTable {
    private Cell[][] cells = new Cell[8][8];
    private List<NipObserver> observers = new ArrayList<NipObserver>();

    NipTable() {
        this.setCells();
        this.setNeighbors();
    }

    void initTable() {
        this.cells[3][3].putStone(new NipStone(NipStone.Color.WHITE));
        this.cells[3][4].putStone(new NipStone(NipStone.Color.BLACK));
        this.cells[4][3].putStone(new NipStone(NipStone.Color.BLACK));
        this.cells[4][4].putStone(new NipStone(NipStone.Color.WHITE));
    }

    private void setCells() {
        int i = 2;
        while (i <= 5) {
            this.cells[0][i] = new Cell(0, i);
            this.cells[7][i] = new Cell(7, i);
            ++i;
        }
        i = 1;
        while (i <= 6) {
            this.cells[1][i] = new Cell(1, i);
            this.cells[6][i] = new Cell(6, i);
            ++i;
        }
        i = 0;
        while (i <= 7) {
            int j = 2;
            while (j <= 5) {
                this.cells[j][i] = new Cell(j, i);
                ++j;
            }
            ++i;
        }
    }

    private void setNeighbors() {
        int i = 0;
        while (i <= 7) {
            int j = 0;
            while (j <= 7) {
                Cell cell = this.getCell(i, j);
                Position[] positionArray = Position.values();
                int n = positionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Position pos = positionArray[n2];
                    if (cell != null && pos != Position.CIRCLE_RIGHT && pos != Position.CIRCLE_LEFT) {
                        cell.setNeighbor(pos, this.getCell(i + pos.i, j + pos.j));
                    }
                    ++n2;
                }
                ++j;
            }
            ++i;
        }
        this.cells[0][2].setNeighbor(Position.CIRCLE_RIGHT, this.cells[1][1]);
        i = 3;
        while (i <= 5) {
            this.cells[0][i].setNeighbor(Position.CIRCLE_RIGHT, this.cells[0][i - 1]);
            ++i;
        }
        this.cells[1][6].setNeighbor(Position.CIRCLE_RIGHT, this.cells[0][5]);
        this.cells[2][7].setNeighbor(Position.CIRCLE_RIGHT, this.cells[1][6]);
        i = 3;
        while (i <= 5) {
            this.cells[i][7].setNeighbor(Position.CIRCLE_RIGHT, this.cells[i - 1][7]);
            ++i;
        }
        this.cells[6][6].setNeighbor(Position.CIRCLE_RIGHT, this.cells[5][7]);
        this.cells[7][5].setNeighbor(Position.CIRCLE_RIGHT, this.cells[6][6]);
        i = 4;
        while (i >= 2) {
            this.cells[7][i].setNeighbor(Position.CIRCLE_RIGHT, this.cells[7][i + 1]);
            --i;
        }
        this.cells[6][1].setNeighbor(Position.CIRCLE_RIGHT, this.cells[7][2]);
        this.cells[5][0].setNeighbor(Position.CIRCLE_RIGHT, this.cells[6][1]);
        i = 4;
        while (i >= 2) {
            this.cells[i][0].setNeighbor(Position.CIRCLE_RIGHT, this.cells[i + 1][0]);
            --i;
        }
        this.cells[1][1].setNeighbor(Position.CIRCLE_RIGHT, this.cells[2][0]);
        i = 2;
        while (i <= 4) {
            this.cells[0][i].setNeighbor(Position.CIRCLE_LEFT, this.cells[0][i + 1]);
            ++i;
        }
        this.cells[0][5].setNeighbor(Position.CIRCLE_LEFT, this.cells[1][6]);
        this.cells[1][6].setNeighbor(Position.CIRCLE_LEFT, this.cells[2][7]);
        i = 2;
        while (i <= 4) {
            this.cells[i][7].setNeighbor(Position.CIRCLE_LEFT, this.cells[i + 1][7]);
            ++i;
        }
        this.cells[5][7].setNeighbor(Position.CIRCLE_LEFT, this.cells[6][6]);
        this.cells[6][6].setNeighbor(Position.CIRCLE_LEFT, this.cells[7][5]);
        i = 5;
        while (i >= 3) {
            this.cells[7][i].setNeighbor(Position.CIRCLE_LEFT, this.cells[7][i - 1]);
            --i;
        }
        this.cells[7][2].setNeighbor(Position.CIRCLE_LEFT, this.cells[6][1]);
        this.cells[6][1].setNeighbor(Position.CIRCLE_LEFT, this.cells[5][0]);
        i = 5;
        while (i >= 3) {
            this.cells[i][0].setNeighbor(Position.CIRCLE_LEFT, this.cells[i - 1][0]);
            --i;
        }
        this.cells[2][0].setNeighbor(Position.CIRCLE_LEFT, this.cells[1][1]);
        this.cells[1][1].setNeighbor(Position.CIRCLE_LEFT, this.cells[0][2]);
    }

    private Cell getCell(int row, int column) {
        if (row < 0 || row > 7) {
            return null;
        }
        if (!(row != 0 && row != 7 || column >= 2 && column <= 5)) {
            return null;
        }
        if (!(row != 1 && row != 6 || column >= 1 && column <= 6)) {
            return null;
        }
        if (column < 0 || column > 7) {
            return null;
        }
        return this.cells[row][column];
    }

    void putStoneAt(int row, int column, NipStone stone) {
        Cell cell = this.getCell(row, column);
        if (cell == null) {
            throw new IllegalArgumentException("\u30bb\u30eb\u306e\u6307\u5b9a\u304c\u4e0d\u6b63\u3067\u3059\u3002");
        }
        if (!this.canPutStoneAt(cell, stone)) {
            throw new IllegalArgumentException("\u305d\u306e\u30bb\u30eb\u306b\u306f\u7f6e\u3051\u307e\u305b\u3093\u3002");
        }
        ArrayList<Position> list = new ArrayList<Position>();
        Position[] positionArray = Position.values();
        int n = positionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Position position = positionArray[n2];
            if (this.scanLine(cell, stone, position)) {
                list.add(position);
            }
            ++n2;
        }
        cell.putStone(stone);
        this.notifyObserversNewStone(row, column, stone.getColor());
        for (Position position : list) {
            this.reverseStones(cell.neighbor(position), stone, position);
        }
        this.notifyObserversStoneColorChangedFinished();
    }

    private void reverseStones(Cell cell, NipStone stone, Position position) {
        if (cell.getStone().equals(stone)) {
            return;
        }
        cell.getStone().changeColor();
        this.notifyObserversStoneColorChanged(cell.getRowIndex(), cell.getColumnIndex(), cell.getStone().getColor());
        this.reverseStones(cell.neighbor(position), stone, position);
    }

    boolean canPutStone(NipStone stone) {
        Cell[][] cellArray = this.cells;
        int n = this.cells.length;
        int n2 = 0;
        while (n2 < n) {
            Cell[] column;
            Cell[] cellArray2 = column = cellArray[n2];
            int n3 = column.length;
            int n4 = 0;
            while (n4 < n3) {
                Cell cell = cellArray2[n4];
                if (cell != null && this.canPutStoneAt(cell, stone)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public boolean canPutStoneAt(int row, int column, NipStone stone) {
        Cell cell = this.getCell(row, column);
        return this.canPutStoneAt(cell, stone);
    }

    private boolean canPutStoneAt(Cell cell, NipStone stone) {
        if (cell == null) {
            return false;
        }
        if (cell.hasStone()) {
            return false;
        }
        Position[] positionArray = Position.values();
        int n = positionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Position position = positionArray[n2];
            if (this.scanLine(cell, stone, position)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean scanLine(Cell cell, NipStone stone, Position position) {
        Cell neighbor = cell.neighbor(position);
        if (neighbor != null && neighbor.hasStone() && !neighbor.getStone().equals(stone)) {
            return this.scanNeighbors(neighbor, position);
        }
        return false;
    }

    private boolean scanNeighbors(Cell cell, Position position) {
        Cell neighbor = cell.neighbor(position);
        if (neighbor == null || !neighbor.hasStone()) {
            return false;
        }
        if (cell.getStone().equals(neighbor.getStone())) {
            return this.scanNeighbors(neighbor, position);
        }
        return true;
    }

    int getBlankCellCount() {
        int count = 0;
        Cell[][] cellArray = this.cells;
        int n = this.cells.length;
        int n2 = 0;
        while (n2 < n) {
            Cell[] column;
            Cell[] cellArray2 = column = cellArray[n2];
            int n3 = column.length;
            int n4 = 0;
            while (n4 < n3) {
                Cell cell = cellArray2[n4];
                if (cell != null && !cell.hasStone()) {
                    ++count;
                }
                ++n4;
            }
            ++n2;
        }
        return count;
    }

    int getStoneCount(NipStone.Color color) {
        int count = 0;
        Cell[][] cellArray = this.cells;
        int n = this.cells.length;
        int n2 = 0;
        while (n2 < n) {
            Cell[] column;
            Cell[] cellArray2 = column = cellArray[n2];
            int n3 = column.length;
            int n4 = 0;
            while (n4 < n3) {
                Cell cell = cellArray2[n4];
                if (cell != null && cell.hasStone() && cell.getStone().getColor().equals((Object)color)) {
                    ++count;
                }
                ++n4;
            }
            ++n2;
        }
        return count;
    }

    public NipStone.Color getCellColor(int row, int column) {
        Cell cell = this.getCell(row, column);
        if (cell == null) {
            throw new IllegalArgumentException("\u30bb\u30eb\u306e\u6307\u5b9a\u304c\u4e0d\u6b63\u3067\u3059\u3002");
        }
        NipStone stone = cell.getStone();
        if (stone != null) {
            return stone.getColor();
        }
        return null;
    }

    void addObservers(NipObserver observer) {
        this.observers.add(observer);
    }

    private void notifyObserversNewStone(int row, int column, NipStone.Color color) {
        for (NipObserver observer : this.observers) {
            observer.onNewStone(row, column, color);
        }
    }

    private void notifyObserversStoneColorChanged(int row, int column, NipStone.Color color) {
        for (NipObserver observer : this.observers) {
            observer.onStoneColorChanged(row, column, color);
        }
    }

    private void notifyObserversStoneColorChangedFinished() {
        for (NipObserver observer : this.observers) {
            observer.onStoneColorChangedFinished();
        }
    }

    NipTable getCopy() {
        NipTable table = new NipTable();
        int i = 0;
        while (i <= 7) {
            int j = 0;
            while (j <= 7) {
                Cell cell = this.getCell(i, j);
                if (cell != null && cell.hasStone()) {
                    table.cells[i][j].putStone((NipStone)cell.getStone().clone());
                }
                ++j;
            }
            ++i;
        }
        return table;
    }

    private class Cell {
        private NipStone stone = null;
        private Map<Position, Cell> neighbors = new HashMap<Position, Cell>();
        private int row;
        private int column;

        Cell(int row, int column) {
            this.row = row;
            this.column = column;
        }

        private void putStone(NipStone stone) {
            if (stone == null) {
                throw new IllegalArgumentException("\u5f15\u6570\u306bnull\u306f\u8a31\u5bb9\u3055\u308c\u307e\u305b\u3093\u3002");
            }
            if (this.stone != null) {
                throw new RuntimeException("\u3059\u3067\u306b\u77f3\u304c\u7f6e\u304b\u308c\u3066\u3044\u307e\u3059\u3002");
            }
            this.stone = stone;
        }

        private boolean hasStone() {
            return this.stone != null;
        }

        private NipStone getStone() {
            return this.stone;
        }

        private void setNeighbor(Position position, Cell cell) {
            this.neighbors.put(position, cell);
        }

        private Cell neighbor(Position position) {
            return this.neighbors.get((Object)position);
        }

        private int getRowIndex() {
            return this.row;
        }

        private int getColumnIndex() {
            return this.column;
        }
    }

    private static enum Position {
        TOP(0, -1),
        TOP_RIGHT(1, -1),
        RIGHT(1, 0),
        BOTTOM_RIGHT(1, 1),
        BOTTOM(0, 1),
        BOTTOM_LEFT(-1, 1),
        LEFT(-1, 0),
        TOP_LEFT(-1, -1),
        CIRCLE_RIGHT(0, 0),
        CIRCLE_LEFT(0, 0);

        private final int i;
        private final int j;

        private Position(int i, int j) {
            this.i = i;
            this.j = j;
        }
    }
}

