/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;

public class Digester {
    public static final String MD5 = "md5";
    public static final String SHA1 = "sha1";
    private final String algorithm;
    private static final HashMap digesters = new HashMap();

    private Digester(String algo) {
        this.algorithm = algo;
    }

    public static final Digester getInstance(String algo) {
        HashMap hashMap = digesters;
        synchronized (hashMap) {
            Digester d = (Digester)digesters.get(algo);
            if (d == null) {
                d = new Digester(algo);
                digesters.put(algo, d);
            }
            return d;
        }
    }

    public String getDigest(String msg) {
        try {
            MessageDigest md = MessageDigest.getInstance(this.algorithm);
            md.update(msg.getBytes());
            byte[] digestData = md.digest();
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < digestData.length) {
                int b;
                int n = b = digestData[i] >= 0 ? digestData[i] : digestData[i] + 256;
                if (b < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toString(b, 16));
                ++i;
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

