/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.core.indexer;

public class InvertedIndexKey {
    public static final int SUPPORTED_DOCUMENTS = 64;
    private final String key;
    protected long document;

    public InvertedIndexKey(String k) {
        this(k, 0L);
    }

    public InvertedIndexKey(String k, long documents) {
        this.key = k;
        this.document = documents;
    }

    public long getDocument() {
        return this.document;
    }

    public void setIndexTermOnDocument(int documentNo, boolean stat) throws IllegalArgumentException {
        if (documentNo < 0 || documentNo > 63) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u6587\u66f8\u756a\u53f7\u306f\u7121\u52b9\u3067\u3059");
        }
        long rad = 1L;
        this.document = stat ? (this.document |= (rad <<= 63 - documentNo)) : (this.document &= (rad ^= 0xFFFFFFFFFFFFFFFFL));
    }

    public boolean isTermFoundInDocument(int documentNo) throws IllegalArgumentException {
        if (documentNo < 0 || documentNo > 63) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u6587\u66f8\u756a\u53f7\u306f\u7121\u52b9\u3067\u3059");
        }
        long rad = 1L;
        return (this.document & (rad <<= 63 - documentNo)) != 0L;
    }

    public String get64bitFormat(long l) {
        String bit64String = "0000000000000000000000000000000000000000000000000000000000000000" + Long.toBinaryString(l);
        return bit64String.substring(bit64String.length() - 64, bit64String.length());
    }

    public static void main(String[] args) {
        InvertedIndexKey r = new InvertedIndexKey("\u30ad\u30fc");
        r.setIndexTermOnDocument(0, true);
        r.setIndexTermOnDocument(1, true);
        r.setIndexTermOnDocument(2, true);
        r.setIndexTermOnDocument(3, true);
        System.err.println(r.toString());
    }
}

