/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.core.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.logical_paradox.koike.core.parser.ParserException;
import org.logical_paradox.koike.core.parser.Term;

public class Parser {
    private int ngramLength;

    public Parser(int ngram) {
        this.ngramLength = ngram;
    }

    public Term[] parse(String doc) throws ParserException {
        HashMap<String, Term> map = new HashMap<String, Term>();
        int loopCnt = doc.length() - (this.ngramLength - 1);
        if (loopCnt <= 0) {
            throw new ParserException("\u4e0e\u3048\u3089\u308c\u305f\u6587\u5b57\u5217\u306e\u9577\u3055\u306b\u5bfe\u3057\u3066N-gram\u5206\u5272\u6570\u304c\u5927\u304d\u3059\u304e\u307e\u3059");
        }
        int cnt = 0;
        while (cnt < loopCnt) {
            int tokenLength = this.ngramLength - (cnt - loopCnt <= 0 ? 0 : cnt - loopCnt);
            String token = doc.substring(cnt, cnt + tokenLength);
            Term key = (Term)map.get(token);
            if (key == null) {
                key = new Term(token);
            }
            key.add(cnt);
            map.put(token, key);
            ++cnt;
        }
        ArrayList list = new ArrayList();
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list.toArray(new Term[0]);
    }

    public String[] split(String doc) throws ParserException {
        int loopCnt = doc.length() - (this.ngramLength - 1);
        if (loopCnt <= 0) {
            throw new ParserException("\u4e0e\u3048\u3089\u308c\u305f\u6587\u5b57\u5217\u306e\u9577\u3055\u306b\u5bfe\u3057\u3066N-gram\u5206\u5272\u6570\u304c\u5927\u304d\u3059\u304e\u307e\u3059");
        }
        String[] tokens = new String[loopCnt];
        int cnt = 0;
        while (cnt < loopCnt) {
            int tokenLength = this.ngramLength - (cnt - loopCnt <= 0 ? 0 : cnt - loopCnt);
            tokens[cnt] = doc.substring(cnt, cnt + tokenLength);
            ++cnt;
        }
        return tokens;
    }
}

