/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.core.parser;

import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.logical_paradox.koike.core.parser.Parser;
import org.logical_paradox.koike.core.parser.ParserException;
import org.logical_paradox.koike.core.parser.Term;

public class ParserTest
extends TestCase {
    public ParserTest(String arg0) {
        super(arg0);
    }

    public void testTooShortDocument() throws ParserException {
        String text = "n-gram\u6570\u306b\u5bfe\u3057\u3066";
        Parser p = new Parser(12);
        try {
            p.parse(text);
            Assert.fail();
        }
        catch (ParserException parserException) {
            // empty catch block
        }
        p = new Parser(11);
        p.parse(text);
    }

    public void testParserResult() throws ParserException {
        String text = "\u5206\u5272\u51e6\u7406\u4e2d\u306b\u767a\u751f\u3057\u305f\u4f8b\u5916\u51e6\u7406";
        Term[] terms = new Parser(2).parse(text);
        Assert.assertTrue((boolean)this.contains(terms, "\u5206\u5272"));
        Assert.assertTrue((boolean)this.contains(terms, "\u5272\u51e6"));
        Assert.assertTrue((boolean)this.contains(terms, "\u51e6\u7406"));
        Assert.assertTrue((boolean)this.contains(terms, "\u7406\u4e2d"));
        Assert.assertTrue((boolean)this.contains(terms, "\u4e2d\u306b"));
        Assert.assertTrue((boolean)this.contains(terms, "\u306b\u767a"));
        Assert.assertTrue((boolean)this.contains(terms, "\u767a\u751f"));
        Assert.assertTrue((boolean)this.contains(terms, "\u751f\u3057"));
        Assert.assertTrue((boolean)this.contains(terms, "\u3057\u305f"));
        Assert.assertTrue((boolean)this.contains(terms, "\u305f\u4f8b"));
        Assert.assertTrue((boolean)this.contains(terms, "\u4f8b\u5916"));
        Assert.assertTrue((boolean)this.contains(terms, "\u5916\u51e6"));
        Assert.assertEquals((int)12, (int)terms.length);
        Term term = this.getTerm(terms, "\u51e6\u7406");
        Iterator it = term.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((int)2, (int)((Integer)it.next()));
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((int)12, (int)((Integer)it.next()));
        Assert.assertFalse((boolean)it.hasNext());
    }

    protected Term getTerm(Term[] base, String term) {
        int i = 0;
        while (i < base.length) {
            if (base[i].getTerm().equals(term)) {
                return base[i];
            }
            ++i;
        }
        return null;
    }

    protected boolean contains(Term[] base, String term) {
        return this.getTerm(base, term) != null;
    }
}

