/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.core.search;

import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.Location;

public class InvertedIndexTest
extends TestCase {
    public InvertedIndexTest(String arg0) {
        super(arg0);
    }

    public void testEquals() {
        InvertedIndex a = new InvertedIndex("NODEID00001", 1002, 12L);
        InvertedIndex b = new InvertedIndex("NODEID00001", 1002, 292L);
        Assert.assertEquals((Object)a, (Object)b);
    }

    public void testNotEquals() {
        InvertedIndex a = new InvertedIndex("NODEID00001", 1002, 12L);
        InvertedIndex b = new InvertedIndex("NODEID00002", 1002, 292L);
        Assert.assertFalse((boolean)a.equals(null));
        Assert.assertFalse((boolean)a.equals(b));
        b = new InvertedIndex("NODEID00001", 1302, 292L);
        Assert.assertFalse((boolean)a.equals(b));
    }

    public void testHashCodeEquals() {
        InvertedIndex a = new InvertedIndex("NODEID00001", 1002, 12L);
        InvertedIndex b = new InvertedIndex("NODEID00001", 1002, 292L);
        Assert.assertEquals((int)a.hashCode(), (int)b.hashCode());
    }

    public void testHashCodeNotEquals() {
        InvertedIndex a = new InvertedIndex("NODEID00001", 1002, 12L);
        InvertedIndex b = new InvertedIndex("NODEID00002", 1002, 292L);
        Assert.assertFalse((a.hashCode() == b.hashCode() ? 1 : 0) != 0);
        b = new InvertedIndex("NODEID00001", 1003, 12L);
        Assert.assertFalse((a.hashCode() == b.hashCode() ? 1 : 0) != 0);
    }

    public void testEqualsAndHashCodeRelation() {
        InvertedIndex a = new InvertedIndex("NODEID00001", 1002, 12L);
        InvertedIndex b = new InvertedIndex("NODEID00001", 1002, 292L);
        Assert.assertTrue((a.equals(b) && a.hashCode() == b.hashCode() ? 1 : 0) != 0);
    }

    public void testGettingLocation() {
        InvertedIndex src = new InvertedIndex("NODE00001", 2999, 121L);
        Location l1 = new Location("NODE00001", 32768, 1992);
        Location l2 = new Location("NODE00001", 16384, 999);
        src.addLocation(l1);
        src.addLocation(l2);
        Assert.assertSame((Object)l1, (Object)src.getLocation(32768, 1992));
        Assert.assertSame((Object)l2, (Object)src.getLocation(16384, 999));
        Assert.assertNotSame((Object)l1, (Object)src.getLocation(16383, 332));
    }

    public void testRemovingLocation() {
        InvertedIndex src = new InvertedIndex("NODE00001", 1, 3L);
        Location l1 = new Location("NODE00001", 64, 1992);
        Location l2 = new Location("NODE00001", 65, 999);
        Location l3 = new Location("NODE00001", 65, 1024);
        src.addLocation(l1);
        src.addLocation(l2);
        src.addLocation(l3);
        src.removeLocation(new Location("NODE00001", 64, 1992));
        Assert.assertNull((Object)src.getLocation(64, 1992));
        Assert.assertEquals((long)2L, (long)src.getDocumentAvailability());
        src.removeLocation(new Location("NODE00001", 65, 999));
        Assert.assertNull((Object)src.getLocation(65, 999));
        Assert.assertNotNull((Object)src.getLocation(65, 1024));
        Assert.assertEquals((long)2L, (long)src.getDocumentAvailability());
    }

    public void testResetDocumentAvailability() {
        InvertedIndex src = new InvertedIndex("NODE00001", 1, 3L);
        Location l1 = new Location("NODE00001", 64, 1992);
        Location l2 = new Location("NODE00001", 65, 999);
        Location l3 = new Location("NODE00001", 65, 1024);
        src.addLocation(l1);
        src.addLocation(l2);
        src.addLocation(l3);
        src.setDocumentAvailability(1L);
        Assert.assertNotNull((Object)src.getLocation(64, 1992));
        Assert.assertNull((Object)src.getLocation(65, 999));
        Assert.assertNull((Object)src.getLocation(65, 1024));
    }

    public void testLocationIterator() {
        InvertedIndex src = new InvertedIndex("NODE00001", 1, 3L);
        Location l1 = new Location("NODE00001", 64, 1992);
        Location l2 = new Location("NODE00001", 65, 999);
        Location l3 = new Location("NODE00001", 65, 1024);
        src.addLocation(l1);
        src.addLocation(l2);
        src.addLocation(l3);
        Iterator it = src.iteratorLocations();
        Object o = it.next();
        Assert.assertTrue((l1 == o || l2 == o || l3 == o ? 1 : 0) != 0);
        o = it.next();
        Assert.assertTrue((l1 == o || l2 == o || l3 == o ? 1 : 0) != 0);
        o = it.next();
        Assert.assertTrue((l1 == o || l2 == o || l3 == o ? 1 : 0) != 0);
        Assert.assertFalse((boolean)it.hasNext());
    }

    public void testCopyConstructor() {
        InvertedIndex src = new InvertedIndex("NODE00001", 2999, 121L);
        Location l1 = new Location("NODE00001", 32768, 1992);
        Location l2 = new Location("NODE00001", 16384, 999);
        src.addLocation(l1);
        src.addLocation(l2);
        InvertedIndex dst = new InvertedIndex(src);
        Assert.assertEquals((String)src.getNodeId(), (String)dst.getNodeId());
        Assert.assertEquals((int)src.getBlockNo(), (int)dst.getBlockNo());
        Assert.assertEquals((long)src.getDocumentAvailability(), (long)dst.getDocumentAvailability());
        Assert.assertEquals((Object)src, (Object)dst);
        Assert.assertSame((Object)src.getLocation(32768, 1992), (Object)dst.getLocation(32768, 1992));
        Assert.assertSame((Object)src.getLocation(16384, 999), (Object)dst.getLocation(16384, 999));
    }

    public void testClone() throws CloneNotSupportedException {
        InvertedIndex src = new InvertedIndex("NODE00001", 2999, 121L);
        Location l1 = new Location("NODE00001", 32768, 1992);
        Location l2 = new Location("NODE00001", 16384, 999);
        src.addLocation(l1);
        src.addLocation(l2);
        InvertedIndex dst = (InvertedIndex)src.clone();
        Assert.assertEquals((String)src.getNodeId(), (String)dst.getNodeId());
        Assert.assertEquals((int)src.getBlockNo(), (int)dst.getBlockNo());
        Assert.assertEquals((long)src.getDocumentAvailability(), (long)dst.getDocumentAvailability());
        Assert.assertEquals((Object)src, (Object)dst);
        Assert.assertSame((Object)src.getLocation(32768, 1992), (Object)dst.getLocation(32768, 1992));
        Assert.assertSame((Object)src.getLocation(16384, 999), (Object)dst.getLocation(16384, 999));
    }
}

