/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.core.search;

import java.util.ArrayList;
import java.util.Iterator;
import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.Location;

public class KoikeIndexResultSet {
    private ArrayList invertedIndexes = new ArrayList();

    public boolean isLocated(String nodeId, int docno, int offset) {
        int blkno = docno / 64;
        InvertedIndex iidx = this.getInvertedIndex(nodeId, blkno);
        if (iidx == null) {
            return false;
        }
        Location found = iidx.getLocation(docno, offset);
        return found != null;
    }

    public void addInvertedIndex(InvertedIndex iidx) {
        ArrayList arrayList = this.invertedIndexes;
        synchronized (arrayList) {
            this.invertedIndexes.remove(iidx);
            this.invertedIndexes.add(iidx);
        }
    }

    public boolean isEmpty() {
        return this.invertedIndexes.size() == 0;
    }

    public void clear() {
        this.invertedIndexes.clear();
    }

    public InvertedIndex getInvertedIndex(String nodeId, int blkno) {
        return this.getInvertedIndex(new InvertedIndex(nodeId, blkno, 0L));
    }

    public InvertedIndex getInvertedIndex(InvertedIndex iidx) {
        ArrayList arrayList = this.invertedIndexes;
        synchronized (arrayList) {
            int index = this.invertedIndexes.indexOf(iidx);
            if (index < 0) {
                return null;
            }
            return (InvertedIndex)this.invertedIndexes.get(index);
        }
    }

    public void removeInvertedIndex(InvertedIndex iidx) {
        this.invertedIndexes.remove(iidx);
    }

    public Iterator iteratorInvertedIndexes() {
        return this.invertedIndexes.iterator();
    }

    public Object clone() throws CloneNotSupportedException {
        KoikeIndexResultSet result = new KoikeIndexResultSet();
        result.invertedIndexes = (ArrayList)this.invertedIndexes.clone();
        return result;
    }
}

