/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.core.search;

import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;

public class KoikeIndexResultSetTest
extends TestCase {
    public KoikeIndexResultSetTest(String arg0) {
        super(arg0);
    }

    public void testInvertedIndexCount() {
        KoikeIndexResultSet rs = new KoikeIndexResultSet();
        Assert.assertTrue((boolean)rs.isEmpty());
        rs.addInvertedIndex(new InvertedIndex("NODE00001", 32, 15L));
        Assert.assertFalse((boolean)rs.isEmpty());
        rs.removeInvertedIndex(new InvertedIndex("NODE00001", 32, 100L));
        Assert.assertTrue((boolean)rs.isEmpty());
    }

    public void testClone() throws CloneNotSupportedException {
        KoikeIndexResultSet rs = new KoikeIndexResultSet();
        InvertedIndex i1 = new InvertedIndex("NODE00001", 32, 15L);
        InvertedIndex i2 = new InvertedIndex("NODE00001", 33, 24L);
        InvertedIndex i3 = new InvertedIndex("NODE00002", 99, 124L);
        rs.addInvertedIndex(i1);
        rs.addInvertedIndex(i2);
        rs.addInvertedIndex(i3);
        KoikeIndexResultSet rs2 = (KoikeIndexResultSet)rs.clone();
        Iterator it1 = rs.iteratorInvertedIndexes();
        Iterator it2 = rs2.iteratorInvertedIndexes();
        Assert.assertEquals(it1.next(), it2.next());
        Assert.assertEquals(it1.next(), it2.next());
        Assert.assertEquals(it1.next(), it2.next());
    }

    public void testClear() {
        KoikeIndexResultSet rs = new KoikeIndexResultSet();
        InvertedIndex i1 = new InvertedIndex("NODE00001", 32, 15L);
        InvertedIndex i2 = new InvertedIndex("NODE00001", 33, 24L);
        InvertedIndex i3 = new InvertedIndex("NODE00002", 99, 124L);
        rs.addInvertedIndex(i1);
        rs.addInvertedIndex(i2);
        rs.addInvertedIndex(i3);
        Assert.assertFalse((boolean)rs.isEmpty());
        rs.clear();
        Assert.assertTrue((boolean)rs.isEmpty());
    }
}

