/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.core.search;

import java.io.FileInputStream;
import java.util.Properties;
import org.logical_paradox.koike.core.KoikeConfig;
import org.logical_paradox.koike.core.document.DocumentAccessor;
import org.logical_paradox.koike.core.indexer.IndexAccessor;
import org.logical_paradox.koike.core.parser.Parser;
import org.logical_paradox.koike.core.search.SearchCondition;
import org.logical_paradox.koike.core.search.SearchException;
import org.logical_paradox.koike.core.search.SearchResult;

public abstract class SearchEngine {
    private KoikeConfig config;
    private IndexAccessor indexAccessor;
    private DocumentAccessor documentAccessor;
    private Parser parser;

    protected SearchEngine() throws Exception {
        this.init();
    }

    protected void init() throws Exception {
        Properties p = new Properties();
        p.load(new FileInputStream("conf/koike.conf"));
        this.setConfig(this.config);
    }

    protected void setConfig(KoikeConfig config_) {
        this.config = config_;
    }

    protected KoikeConfig getConfig() {
        return this.config;
    }

    public abstract SearchResult search(SearchCondition var1) throws SearchException;

    protected synchronized Parser getParser() {
        if (this.parser == null) {
            this.parser = new Parser(this.config.getNgramTermLength());
        }
        return this.parser;
    }

    protected synchronized IndexAccessor getIndexAccessor() throws SearchException {
        if (this.indexAccessor == null) {
            try {
                this.indexAccessor = this.getConfig().getInterfaceFactory().getIndexAccessor();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SearchException(e);
            }
        }
        return this.indexAccessor;
    }

    protected synchronized DocumentAccessor getDocumentAccessor() throws SearchException {
        if (this.documentAccessor == null) {
            try {
                this.documentAccessor = this.getConfig().getInterfaceFactory().getDocumentAccessor();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SearchException(e);
            }
        }
        return this.documentAccessor;
    }
}

