/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.rss;

import java.util.Iterator;
import org.logical_paradox.koike.core.ConcreteInterfaceFactory;
import org.logical_paradox.koike.core.document.DocumentAccessor;
import org.logical_paradox.koike.core.indexer.IndexAccessor;
import org.logical_paradox.koike.core.search.SearchConditionOptimizer;
import org.logical_paradox.koike.rss.document.RSSDocumentAccessor;
import org.logical_paradox.koike.rss.document.RemoteQueueCollection;
import org.logical_paradox.koike.rss.indexer.RSSIndexAccessor;
import org.logical_paradox.koike.rss.search.RSSSearchConditionOptimizer;
import org.logical_paradox.rss.idxsv.IndexConnection;
import org.logical_paradox.rss.idxsv.RSSIndexServer;
import org.logical_paradox.rss.lookup.Lookup;
import org.logical_paradox.rss.lookup.LookupFactory;
import org.logical_paradox.rss.oqs4r.OQSConnection;
import org.logical_paradox.rss.oqs4r.ObjectQueueServer;
import org.logical_paradox.rss.rcm.ContentsFinder;
import org.logical_paradox.rss.rcm.RSSContentsMngrService;

public class RSSConcreteInterfaceFactory
extends ConcreteInterfaceFactory {
    private Lookup lookup;
    private OQSConnection qConnection;
    private ContentsFinder finder;
    private IndexConnection idxConnection;

    public RSSConcreteInterfaceFactory(String param) throws Exception {
        super(param);
    }

    public DocumentAccessor getDocumentAccessor() throws Exception {
        return new RSSDocumentAccessor(this.finder);
    }

    public IndexAccessor getIndexAccessor() throws Exception {
        return new RSSIndexAccessor(this.idxConnection);
    }

    public Iterator getRemoteQueueIterator() throws Exception {
        return new RemoteQueueCollection(this.qConnection).iterator();
    }

    public SearchConditionOptimizer getOptimizer() throws Exception {
        return new RSSSearchConditionOptimizer();
    }

    public void setup() throws Exception {
        this.lookup = LookupFactory.getLookup((String)this.getInitparam());
        ObjectQueueServer queue = (ObjectQueueServer)this.lookup.lookup(40);
        this.qConnection = queue.getConnection();
        RSSContentsMngrService rcm = (RSSContentsMngrService)this.lookup.lookup(20);
        this.finder = rcm.getFinder();
        RSSIndexServer idxsv = (RSSIndexServer)this.lookup.lookup(30);
        this.idxConnection = idxsv.getClient();
    }
}

