/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.rss.search;

import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.logical_paradox.koike.core.KoikeConfig;
import org.logical_paradox.koike.core.search.Element;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;
import org.logical_paradox.koike.core.search.ResultSet;
import org.logical_paradox.koike.core.search.SearchCondition;
import org.logical_paradox.koike.core.search.SearchException;
import org.logical_paradox.koike.core.search.SearchResult;
import org.logical_paradox.koike.rss.search.RSSSearchEngine;
import org.logical_paradox.koike.tools.isys.StubIndexAccessor;

public class RSSSearchEngineTest
extends TestCase {
    private RSSSearchEngineImpl searchEngine;

    public RSSSearchEngineTest(String arg0) {
        super(arg0);
    }

    public void testExecuteQueryAndFoundAnswers() throws SearchException {
        KoikeIndexResultSet rs = this.searchEngine.executeQuery("\u30b5\u30fc\u30c1\u30a8\u30f3\u30b8\u30f3");
        RSSSearchEngineTest.assertNotNull((Object)rs);
        RSSSearchEngineTest.assertFalse((boolean)rs.isEmpty());
    }

    public void testExecuteQueryAndNotFound() throws SearchException {
        KoikeIndexResultSet rs = this.searchEngine.executeQuery("\u30a4\u30f3\u30c7\u30af\u30b9");
        RSSSearchEngineTest.assertNull((Object)rs);
    }

    public void testExecuteQueryWith1Letter() {
        try {
            this.searchEngine.executeQuery("\u30a4");
            RSSSearchEngineTest.fail();
        }
        catch (SearchException searchException) {
            // empty catch block
        }
    }

    public void testSearchWith1Word() throws SearchException {
        SearchCondition condition = new SearchCondition();
        condition.setDispnum(10);
        condition.setStartp(0);
        Element e = new Element(64, "Open-SEDK");
        condition.addChildNode(e);
        SearchResult sr = this.searchEngine.search(condition);
        ResultSet[] results = sr.getResultSet();
        RSSSearchEngineTest.assertNotNull((Object)results);
        RSSSearchEngineTest.assertTrue((results.length == 2 ? 1 : 0) != 0);
    }

    public void testSearchAndNotFound() throws SearchException {
        SearchCondition condition = new SearchCondition();
        condition.setDispnum(10);
        condition.setStartp(0);
        Element e = new Element(64, "Open-SpDK");
        condition.addChildNode(e);
        SearchResult sr = this.searchEngine.search(condition);
        RSSSearchEngineTest.assertNull((Object)sr);
    }

    public void testSearchWith2Word() throws SearchException {
        SearchCondition condition = new SearchCondition();
        condition.setDispnum(10);
        condition.setStartp(0);
        condition.addChildNode(new Element(64, "Open-SEDK"));
        condition.addChildNode(new Element(64, "SETI@home\u307f\u305f\u3044\u306a\u611f\u3058"));
        SearchResult sr = this.searchEngine.search(condition);
        ResultSet[] results = sr.getResultSet();
        RSSSearchEngineTest.assertNotNull((Object)results);
        RSSSearchEngineTest.assertTrue((results.length == 1 ? 1 : 0) != 0);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.searchEngine = new RSSSearchEngineImpl();
    }

    class RSSSearchEngineImpl
    extends RSSSearchEngine {
        public KoikeIndexResultSet executeQuery(String keyword) throws SearchException {
            return super.executeQuery(keyword);
        }

        protected void init() throws Exception {
            Properties p = new Properties();
            p.setProperty("INTERFACE_FACTORY", "org.logical_paradox.koike.tools.isys.StubConcreteInterfaceFactory");
            p.setProperty("N_GRAM_TERM_LENGTH", "2");
            this.setConfig(new KoikeConfig(p));
            StubIndexAccessor stubixr = (StubIndexAccessor)this.getIndexAccessor();
            stubixr.load();
        }

        public KoikeIndexResultSet retrieve(List searchWords, Element element) throws SearchException {
            return super.retrieve(searchWords, element);
        }
    }
}

