/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.rss.search.lo;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;
import org.logical_paradox.koike.rss.search.lo.LogicalOperationException;
import org.logical_paradox.koike.rss.search.lo.LogicalOperator;
import org.logical_paradox.koike.rss.search.lo.LogicalOperatorFactory;

public class AndLogicalOperatorTest
extends TestCase {
    private LogicalOperator op;

    public AndLogicalOperatorTest(String arg0) {
        super(arg0);
    }

    public void testOperationWithNullArgument() throws LogicalOperationException {
        Assert.assertNull((Object)this.op.execute(null));
        Assert.assertNull((Object)this.op.execute(new KoikeIndexResultSet[0]));
    }

    public void testOperationWithSingleArgument() throws LogicalOperationException {
        KoikeIndexResultSet rs = new KoikeIndexResultSet();
        rs.addInvertedIndex(new InvertedIndex("NODE00001", 100, 20L));
        rs.addInvertedIndex(new InvertedIndex("NODE00002", 100, 20L));
        rs.addInvertedIndex(new InvertedIndex("NODE00002", 103, 15L));
        KoikeIndexResultSet[] results = this.op.execute(new KoikeIndexResultSet[]{rs});
        Assert.assertNotNull((Object)results);
        Assert.assertTrue((results.length > 0 ? 1 : 0) != 0);
        Assert.assertSame((Object)rs, (Object)results[0]);
    }

    public void testNoResult() throws LogicalOperationException {
        KoikeIndexResultSet rs1 = new KoikeIndexResultSet();
        rs1.addInvertedIndex(new InvertedIndex("NODE00001", 100, 20L));
        rs1.addInvertedIndex(new InvertedIndex("NODE00002", 100, 20L));
        rs1.addInvertedIndex(new InvertedIndex("NODE00002", 103, 15L));
        KoikeIndexResultSet rs2 = new KoikeIndexResultSet();
        rs2.addInvertedIndex(new InvertedIndex("NODE00003", 100, 20L));
        rs2.addInvertedIndex(new InvertedIndex("NODE00002", 104, 20L));
        rs2.addInvertedIndex(new InvertedIndex("NODE00002", 99, 15L));
        KoikeIndexResultSet[] results = this.op.execute(new KoikeIndexResultSet[]{rs1, rs2});
        Assert.assertNull((Object)results);
    }

    public void testMatchPattern01() throws LogicalOperationException {
        KoikeIndexResultSet rs1 = new KoikeIndexResultSet();
        rs1.addInvertedIndex(new InvertedIndex("NODE00001", 100, 20L));
        rs1.addInvertedIndex(new InvertedIndex("NODE00002", 100, 20L));
        rs1.addInvertedIndex(new InvertedIndex("NODE00002", 103, 15L));
        KoikeIndexResultSet rs2 = new KoikeIndexResultSet();
        rs2.addInvertedIndex(new InvertedIndex("NODE00003", 100, 20L));
        rs2.addInvertedIndex(new InvertedIndex("NODE00002", 100, 7L));
        rs2.addInvertedIndex(new InvertedIndex("NODE00002", 99, 15L));
        KoikeIndexResultSet[] results = this.op.execute(new KoikeIndexResultSet[]{rs1, rs2});
        Assert.assertNotNull((Object)results);
        Assert.assertTrue((results.length > 0 ? 1 : 0) != 0);
        KoikeIndexResultSet result = results[0];
        Assert.assertNull((Object)result.getInvertedIndex("NODE00001", 100));
        Assert.assertNotNull((Object)result.getInvertedIndex("NODE00002", 100));
        Assert.assertNull((Object)result.getInvertedIndex("NODE00002", 103));
        Assert.assertEquals((long)4L, (long)result.getInvertedIndex("NODE00002", 100).getDocumentAvailability());
    }

    public void testMatchPattern02() throws LogicalOperationException {
        KoikeIndexResultSet rs1 = new KoikeIndexResultSet();
        rs1.addInvertedIndex(new InvertedIndex("NODE00001", 100, 20L));
        rs1.addInvertedIndex(new InvertedIndex("NODE00002", 100, 20L));
        rs1.addInvertedIndex(new InvertedIndex("NODE00002", 99, 21L));
        KoikeIndexResultSet rs2 = new KoikeIndexResultSet();
        rs2.addInvertedIndex(new InvertedIndex("NODE00003", 100, 20L));
        rs2.addInvertedIndex(new InvertedIndex("NODE00002", 100, 7L));
        rs2.addInvertedIndex(new InvertedIndex("NODE00002", 99, 13L));
        KoikeIndexResultSet rs3 = new KoikeIndexResultSet();
        rs3.addInvertedIndex(new InvertedIndex("NODE00002", 100, 20L));
        rs3.addInvertedIndex(new InvertedIndex("NODE00004", 10, 50L));
        rs3.addInvertedIndex(new InvertedIndex("NODE00002", 99, 6L));
        KoikeIndexResultSet[] results = this.op.execute(new KoikeIndexResultSet[]{rs1, rs2, rs3});
        Assert.assertNotNull((Object)results);
        Assert.assertTrue((results.length > 0 ? 1 : 0) != 0);
        KoikeIndexResultSet result = results[0];
        Assert.assertNull((Object)result.getInvertedIndex("NODE00001", 100));
        Assert.assertNull((Object)result.getInvertedIndex("NODE00003", 100));
        Assert.assertNull((Object)result.getInvertedIndex("NODE00004", 10));
        Assert.assertNotNull((Object)result.getInvertedIndex("NODE00002", 99));
        Assert.assertNotNull((Object)result.getInvertedIndex("NODE00002", 100));
        Assert.assertEquals((long)4L, (long)result.getInvertedIndex("NODE00002", 99).getDocumentAvailability());
        Assert.assertEquals((long)4L, (long)result.getInvertedIndex("NODE00002", 100).getDocumentAvailability());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.op = LogicalOperatorFactory.getOperator(1);
    }
}

