/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.koike.rss.search.lo;

import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.logical_paradox.koike.core.search.InvertedIndex;
import org.logical_paradox.koike.core.search.KoikeIndexResultSet;
import org.logical_paradox.koike.core.search.Location;
import org.logical_paradox.koike.rss.search.lo.LogicalOperationException;
import org.logical_paradox.koike.rss.search.lo.LogicalOperator;
import org.logical_paradox.koike.rss.search.lo.LogicalOperatorFactory;

public class SeqLogicalOperatorTest
extends TestCase {
    private LogicalOperator op;

    public SeqLogicalOperatorTest(String arg0) {
        super(arg0);
    }

    public void testNoArgument() throws LogicalOperationException {
        Assert.assertNull((Object)this.op.execute(null));
        Assert.assertNull((Object)this.op.execute(new KoikeIndexResultSet[0]));
    }

    public void testNoLocation() throws LogicalOperationException {
        KoikeIndexResultSet rs1 = new KoikeIndexResultSet();
        rs1.addInvertedIndex(new InvertedIndex("NODE00001", 100, 0L));
        rs1.addInvertedIndex(new InvertedIndex("NODE00002", 255, 0L));
        KoikeIndexResultSet rs2 = new KoikeIndexResultSet();
        rs2.addInvertedIndex(new InvertedIndex("NODE00003", 100, 0L));
        KoikeIndexResultSet[] result = this.op.execute(new KoikeIndexResultSet[]{rs1, rs2});
        Assert.assertNull((Object)result);
    }

    public void testOperationUsingSingleArgument() throws LogicalOperationException {
        KoikeIndexResultSet rs = new KoikeIndexResultSet();
        InvertedIndex ii1 = new InvertedIndex("NODE10000", 10, 13L);
        ii1.addLocation(new Location("NODE10000", 640, 1033));
        ii1.addLocation(new Location("NODE10000", 655, 1092));
        InvertedIndex ii2 = new InvertedIndex("NODE10001", 99, 15L);
        rs.addInvertedIndex(ii1);
        rs.addInvertedIndex(ii2);
        KoikeIndexResultSet[] results = this.op.execute(new KoikeIndexResultSet[]{rs});
        Assert.assertSame((Object)results[0], (Object)rs);
        Assert.assertFalse((boolean)results[0].isEmpty());
        Iterator iii = results[0].iteratorInvertedIndexes();
        Assert.assertEquals((Object)ii1, iii.next());
        Assert.assertEquals((Object)ii2, iii.next());
        Assert.assertTrue((boolean)results[0].isLocated("NODE10000", 640, 1033));
        Assert.assertTrue((boolean)results[0].isLocated("NODE10000", 655, 1092));
    }

    public void testOperationPattern01() throws LogicalOperationException {
        KoikeIndexResultSet rs1 = new KoikeIndexResultSet();
        InvertedIndex ii11 = new InvertedIndex("NODE00001", 10, 20L);
        ii11.addLocation(new Location("NODE00001", 641, 1024));
        ii11.addLocation(new Location("NODE00001", 641, 1055));
        rs1.addInvertedIndex(ii11);
        KoikeIndexResultSet rs2 = new KoikeIndexResultSet();
        InvertedIndex ii21 = new InvertedIndex("NODE00011", 10, 20L);
        ii21.addLocation(new Location("NODE00011", 642, 199));
        InvertedIndex ii22 = new InvertedIndex("NODE00001", 10, 2L);
        ii22.addLocation(new Location("NODE00001", 641, 1025));
        rs2.addInvertedIndex(ii21);
        rs2.addInvertedIndex(ii22);
        KoikeIndexResultSet rs3 = new KoikeIndexResultSet();
        InvertedIndex ii31 = new InvertedIndex("NODE10001", 1, 3L);
        ii31.addLocation(new Location("NODE10001", 64, 199));
        ii31.addLocation(new Location("NODE10001", 64, 203));
        ii31.addLocation(new Location("NODE10001", 65, 1099));
        InvertedIndex ii32 = new InvertedIndex("NODE00001", 10, 2L);
        ii32.addLocation(new Location("NODE00001", 641, 1026));
        rs3.addInvertedIndex(ii31);
        rs3.addInvertedIndex(ii32);
        KoikeIndexResultSet[] results = this.op.execute(new KoikeIndexResultSet[]{rs1, rs2, rs3});
        Assert.assertNotNull((Object)results);
        Assert.assertEquals((int)1, (int)results.length);
        Assert.assertNotSame((Object)rs1, (Object)results[0]);
        Assert.assertNotSame((Object)rs2, (Object)results[0]);
        Assert.assertNotSame((Object)rs3, (Object)results[0]);
        Assert.assertFalse((boolean)results[0].isEmpty());
        Assert.assertTrue((boolean)results[0].isLocated("NODE00001", 641, 1024));
        Iterator it = results[0].iteratorInvertedIndexes();
        Assert.assertTrue((boolean)it.hasNext());
        InvertedIndex iidx = (InvertedIndex)it.next();
        Location beginningPoint = iidx.getLocation(641, 1024);
        Assert.assertEquals((Object)new Location("NODE00001", 641, 1024), (Object)beginningPoint);
        iidx.removeLocation(beginningPoint);
        Assert.assertFalse((boolean)iidx.hasLocations());
    }

    public void testOperationPattern02() throws LogicalOperationException {
        KoikeIndexResultSet rs1 = new KoikeIndexResultSet();
        InvertedIndex ii11 = new InvertedIndex("NODE00001", 10, 2L);
        ii11.addLocation(new Location("NODE00001", 641, 1024));
        ii11.addLocation(new Location("NODE00001", 641, 1055));
        rs1.addInvertedIndex(ii11);
        KoikeIndexResultSet rs2 = new KoikeIndexResultSet();
        InvertedIndex ii21 = new InvertedIndex("NODE00011", 10, 4L);
        ii21.addLocation(new Location("NODE00011", 642, 199));
        InvertedIndex ii22 = new InvertedIndex("NODE00001", 10, 2L);
        ii22.addLocation(new Location("NODE00001", 641, 1025));
        rs2.addInvertedIndex(ii21);
        rs2.addInvertedIndex(ii22);
        KoikeIndexResultSet rs3 = new KoikeIndexResultSet();
        InvertedIndex ii31 = new InvertedIndex("NODE10001", 1, 3L);
        ii31.addLocation(new Location("NODE10001", 64, 199));
        ii31.addLocation(new Location("NODE10001", 64, 203));
        ii31.addLocation(new Location("NODE10001", 65, 1099));
        InvertedIndex ii32 = new InvertedIndex("NODE00001", 10, 2L);
        ii32.addLocation(new Location("NODE00001", 641, 1029));
        rs3.addInvertedIndex(ii31);
        rs3.addInvertedIndex(ii32);
        KoikeIndexResultSet[] results = this.op.execute(new KoikeIndexResultSet[]{rs1, rs2, rs3});
        Assert.assertNull((Object)results);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.op = LogicalOperatorFactory.getOperator(56);
    }
}

