/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.phalanx;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.logical_paradox.phalanx.binding.condition.Condition;
import org.logical_paradox.phalanx.impl.NgramFTSSearchLogic;

/**
 * ̃WbN𐶐t@Ng
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class SearchLogicFactory {
	/** WbÑ}bv */
	private static final Map map;
	protected final static String NGRAM_FTS_SEARCH_LOGIC = "ngramFtsSearchLogic";

	static {
		HashMap m = new HashMap();
		// N-gramgp錟WbN
		m.put(NGRAM_FTS_SEARCH_LOGIC, new NgramFTSSearchLogic());

		// read onlyȃ}bv̍쐬
		map = Collections.unmodifiableMap(m);
	}

	/**
	 * ɂĎw肳ꂽ^Cv̌WbN𐶐
	 * @param condition 
	 * @return ۂɒS郍WbN
	 */
	public static final SearchLogic getSearchLogic(Condition condition) {
		String searchMethod = condition.getMethod();
		if(searchMethod == null || searchMethod.trim().length() == 0) {
			searchMethod = NGRAM_FTS_SEARCH_LOGIC;
		}

		SearchLogic logic = (SearchLogic)map.get(searchMethod);
		if(logic == null) {
			throw new IllegalArgumentException("undefined search method is specified [" + searchMethod + "]");
		}

		return logic;
	}
}
