/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.thread;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ReadWriteLock {
    private Set _readerThreads = Collections.synchronizedSet(new HashSet());
    private Set _writerThreads = Collections.synchronizedSet(new HashSet());

    public synchronized void beginRead(int msec) throws InterruptedException {
        while (this._writerThreads.size() > 0) {
            this.wait(msec);
        }
        this._readerThreads.add(Thread.currentThread());
    }

    public synchronized void beginWrite(int msec) throws InterruptedException {
        while (this._writerThreads.size() > 0 || this._readerThreads.size() > 0) {
            this.wait(msec);
        }
        this._writerThreads.add(Thread.currentThread());
    }

    public synchronized void endRead() throws InterruptedException {
        if (this._readerThreads.contains(Thread.currentThread())) {
            this._readerThreads.remove(Thread.currentThread());
            this.notifyAll();
        }
    }

    public synchronized void endWrite() throws InterruptedException {
        if (this._writerThreads.contains(Thread.currentThread())) {
            this._writerThreads.remove(Thread.currentThread());
        }
        this.notifyAll();
    }

    public synchronized void beginRead() throws InterruptedException {
        this.beginRead(0);
    }

    public synchronized void beginWrite() throws InterruptedException {
        this.beginWrite(0);
    }

    public synchronized void release() throws InterruptedException {
        this.endWrite();
        this.endRead();
    }
}

