/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.common.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.logical_paradox.common.net.IPAddress;
import org.logical_paradox.common.net.IPv4MaskPair;

public class IPv4Address
extends IPAddress {
    public IPv4Address(InetAddress ip, InetAddress nm) {
        super(ip, nm);
    }

    public IPv4Address(IPv4MaskPair ipm) {
        super(ipm.getIPAddress(), ipm.getNetmask());
    }

    public static IPv4MaskPair getIPv4MaskPair(String addr) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(addr.trim(), "/");
        String partIPAddress = null;
        String partNetMaskBitLength = null;
        boolean rc = true;
        if (!st.hasMoreTokens() || (partIPAddress = st.nextToken()) == null || partIPAddress.trim().length() == 0) {
            rc = false;
        } else if (!st.hasMoreTokens() || (partNetMaskBitLength = st.nextToken()) == null || partNetMaskBitLength.trim().length() == 0) {
            rc = false;
        } else if (st.hasMoreTokens()) {
            rc = false;
        }
        int netMaskBit = 0;
        InetAddress[] ips = new InetAddress[2];
        if (rc) {
            try {
                StringTokenizer ipaTokenizer = new StringTokenizer(String.valueOf(partIPAddress) + ".0.0.0", ".");
                StringBuffer fqIPAddress = new StringBuffer();
                int i = 0;
                while (i < 4) {
                    if (!ipaTokenizer.hasMoreTokens()) {
                        throw new IllegalArgumentException("IP\u30a2\u30c9\u30ec\u30b9\u304c\u304a\u304b\u3057\u3044" + partIPAddress);
                    }
                    if (i > 0) {
                        fqIPAddress.append('.');
                    }
                    fqIPAddress.append(ipaTokenizer.nextToken());
                    ++i;
                }
                ips[0] = InetAddress.getByName(fqIPAddress.toString());
                netMaskBit = Integer.parseInt(partNetMaskBitLength);
                ips[1] = IPv4Address.getNetmaskAddress(netMaskBit);
            }
            catch (UnknownHostException uhe) {
                rc = false;
            }
            catch (NumberFormatException nfe) {
                rc = false;
            }
        }
        if (!rc) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305fIP\u30a2\u30c9\u30ec\u30b9\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u304c\u304a\u304b\u3057\u3044: '" + addr + "'");
        }
        return new IPv4MaskPair(ips[0], ips[1]);
    }

    public static InetAddress getNetmaskAddress(int bitLength) throws UnknownHostException {
        int netmaskAsInt = ~((1 << 32 - bitLength) - 1);
        byte[] netmaskBits = new byte[4];
        int i = 0;
        while (i < 4) {
            netmaskBits[3 - i] = (byte)(netmaskAsInt >> 8 * i & 0xFF);
            ++i;
        }
        return InetAddress.getByAddress(netmaskBits);
    }

    public boolean includes(InetAddress ip) {
        byte[] ipBytes = ip.getAddress();
        byte[] thisIPBytes = this.getIPAddress().getAddress();
        byte[] netmaskBytes = this.getNetmask().getAddress();
        if (ipBytes.length != thisIPBytes.length || ipBytes.length != netmaskBytes.length) {
            return false;
        }
        int i = 0;
        while (i < ipBytes.length) {
            int n = i;
            ipBytes[n] = (byte)(ipBytes[n] & netmaskBytes[i]);
            int n2 = i;
            thisIPBytes[n2] = (byte)(thisIPBytes[n2] & netmaskBytes[i]);
            if (ipBytes[i] != thisIPBytes[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean includes(String ip) {
        boolean rc = false;
        try {
            rc = this.includes(InetAddress.getByName(ip));
        }
        catch (UnknownHostException e) {
            rc = false;
        }
        return rc;
    }
}

