/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.dsr;

import java.io.FileOutputStream;
import java.rmi.Naming;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.RSSSubModule;
import org.logical_paradox.rss.Service;
import org.logical_paradox.rss.dsr.DSRLogWriter;
import org.logical_paradox.rss.dsr.Message;
import org.logical_paradox.rss.dsr.RSSDSRConfig;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.dsr.ServiceList;
import org.logical_paradox.rss.dsr.algorithm.ServiceBindingAlgorithm;
import org.logical_paradox.rss.lookup.LookupFactory;
import org.logical_paradox.rss.util.RandomKeyGenerator;

public class RSSDistributedServiceRegistryImpl
extends UnicastRemoteObject
implements RSSDistributedServiceRegistry,
RSSSubModule {
    public static final String RSS_DSRCONF_PATH = "conf/rssdsr.conf";
    private RSSDSRConfig cfg = null;
    private final Hashtable remoteServices = new Hashtable();
    private final Hashtable bindingAlgorithms = new Hashtable();
    private String endPointURI = null;
    private String dsrConfigPath = null;
    private DSRLogWriter logger;
    private String dsrServiceName;

    public RSSDistributedServiceRegistryImpl() throws RemoteException {
    }

    public RSSDistributedServiceRegistryImpl(String endp) throws RemoteException {
        this();
        this.endPointURI = endp;
    }

    public String[] services(int type) throws RemoteException {
        ServiceList slist = (ServiceList)this.remoteServices.get(new Integer(type));
        if (slist == null) {
            return new String[0];
        }
        return slist.serviceNames();
    }

    public String bind(int type, String serviceName, Remote stub) throws RemoteException {
        ServiceList slist = (ServiceList)this.remoteServices.get(new Integer(type));
        if (slist == null) {
            slist = new ServiceList(this.getBindingAlgorithmByType(type));
        }
        slist.add(serviceName, stub);
        this.remoteServices.put(new Integer(type), slist);
        this.logger.write("\u30ea\u30e2\u30fc\u30c8\u30b5\u30fc\u30d3\u30b9\u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f: " + serviceName + "(" + type + ")");
        return serviceName;
    }

    public String bind(int type, Service stub) throws RemoteException {
        String serviceName = this.getRemoteServiceName(type);
        return this.bind(type, serviceName, stub);
    }

    public void unbind(int type, String nodeId) throws RemoteException {
        ServiceList slist = (ServiceList)this.remoteServices.get(new Integer(type));
        if (slist == null || !slist.contains(nodeId)) {
            throw new RemoteException("\u30bf\u30a4\u30d7" + type + "\u306b\u5bfe\u5fdc\u3059\u308b\u30ea\u30e2\u30fc\u30c8\u30b5\u30fc\u30d3\u30b9\u306f\uff0c\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        slist.remove(nodeId);
    }

    public Remote getService(int type) throws RemoteException {
        ServiceList slist = (ServiceList)this.remoteServices.get(new Integer(type));
        if (slist == null) {
            throw new RemoteException("\u30bf\u30a4\u30d7" + type + "\u306b\u5bfe\u5fdc\u3059\u308b\u30ea\u30e2\u30fc\u30c8\u30b5\u30fc\u30d3\u30b9\u306f\uff0c\u307e\u3060\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        return slist.getService();
    }

    protected String getRemoteServiceName(int type) throws IllegalArgumentException {
        String theKindOfService = null;
        switch (type) {
            case 1: {
                theKindOfService = "DSR/";
                break;
            }
            case 10: {
                theKindOfService = "RNCF/";
                break;
            }
            case 20: {
                theKindOfService = "RCMGR/";
                break;
            }
            case 30: {
                theKindOfService = "IDXSRV/";
                break;
            }
            case 40: {
                theKindOfService = "OQS4R/";
                break;
            }
            default: {
                throw new IllegalArgumentException("SEVICE ID:" + type + "\u306f\uff0c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff0e");
            }
        }
        String serviceName = String.valueOf(theKindOfService) + RandomKeyGenerator.getUniqKey(16);
        return serviceName;
    }

    protected ServiceBindingAlgorithm getBindingAlgorithmByType(int type) throws IllegalArgumentException {
        switch (type) {
            case 1: {
                return this.cfg.getDSRBindingAlgorithm();
            }
            case 10: {
                return this.cfg.getRNodeBindingAlgorithm();
            }
            case 20: {
                return this.cfg.getRCMGRBindingAlgorithm();
            }
            case 30: {
                return this.cfg.getIndexServerBindingAlgorithm();
            }
            case 40: {
                return this.cfg.getOqs4rBindingAlgorithm();
            }
        }
        throw new IllegalArgumentException("SEVICE ID:" + type + "\u306f\uff0c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\uff0e");
    }

    protected void setEndPointURI(String uri) {
        this.endPointURI = uri;
    }

    protected void setDsrConfigPath(String path) {
        this.dsrConfigPath = path;
    }

    public void startModule() throws ModuleException {
        try {
            this.cfg = this.dsrConfigPath == null ? new RSSDSRConfig(RSS_DSRCONF_PATH) : new RSSDSRConfig(this.dsrConfigPath);
            this.logger = new DSRLogWriter(new FileOutputStream("logs/" + this.cfg.getRunLogFilename()));
            this.dsrServiceName = this.cfg.getRSSDistributedServiceRegistry();
            Naming.rebind(this.dsrServiceName, this);
            this.bind(1, this.dsrServiceName, this);
            if (this.endPointURI != null && this.endPointURI.trim().length() > 0) {
                RSSDistributedServiceRegistry buddy = (RSSDistributedServiceRegistry)LookupFactory.getLookup(this.endPointURI).hug(this);
                String buddyName = this.bind(1, buddy);
                this.logger.write("DSR[" + buddyName + "]\u3068\u63a5\u7d9a\u3057\u307e\u3057\u305f");
            }
            this.logger.write("\u5206\u6563\u30b5\u30fc\u30d3\u30b9\u30ec\u30b8\u30b9\u30c8\u30ea '" + this.dsrServiceName + "' \u304c\u958b\u59cb\u3055\u308c\u307e\u3057\u305f\uff0e");
        }
        catch (Exception e) {
            throw new ModuleException(e);
        }
    }

    public void suspendModule() throws ModuleException {
    }

    public void continueModule() throws ModuleException {
    }

    public void stopModule() throws ModuleException {
    }

    public static void main(String[] args) throws Exception {
        try {
            RSSDistributedServiceRegistryImpl selector = new RSSDistributedServiceRegistryImpl();
            System.err.println("\u5f15\u6570=" + args.length);
            if (args.length >= 2) {
                selector.setEndPointURI(args[1]);
            }
            if (args.length >= 3) {
                selector.setDsrConfigPath(args[2]);
            }
            selector.startModule();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public Service[] discover(Message msg) throws RemoteException {
        ServiceList registeredDsr;
        ArrayList<List<Service>> discoveredServices = new ArrayList<List<Service>>();
        ServiceList services = (ServiceList)this.remoteServices.get(new Integer(msg.getDiscoverType()));
        if (services == null) {
            discoveredServices.addAll(services.values());
        }
        if ((registeredDsr = (ServiceList)this.remoteServices.get(new Integer(1))) != null) {
            this.logger.write("\u767a\u898b\u30b9\u30ec\u30c3\u30c9\u3092\u751f\u6210\u3057\u307e\u3059");
            Service[] dsrs = registeredDsr.values().toArray(new Service[0]);
            DiscoveryThread[] threads = new DiscoveryThread[dsrs.length];
            int i = 0;
            while (i < dsrs.length) {
                threads[i] = new DiscoveryThread((RSSDistributedServiceRegistry)dsrs[i], msg);
                threads[i].start();
                this.logger.write("\u767a\u898b\u30b9\u30ec\u30c3\u30c9: " + dsrs[i].getName() + " \u2192 \u958b\u59cb");
                ++i;
            }
            try {
                i = 0;
                while (i < dsrs.length) {
                    threads[i].join();
                    ++i;
                }
            }
            catch (InterruptedException e) {
                this.logger.write("\u767a\u898b\u30b9\u30ec\u30c3\u30c9\u304c\u505c\u6b62\u3057\u307e\u3057\u305f: \u3010\u539f\u56e0\u3011" + e.getMessage());
            }
            this.logger.write("\u767a\u898b\u30b9\u30ec\u30c3\u30c9\u304c\u5168\u3066\u7d42\u4e86");
            i = 0;
            while (i < threads.length) {
                discoveredServices.add(Arrays.asList(threads[i].getResult()));
                ++i;
            }
        }
        return discoveredServices.toArray(new Service[0]);
    }

    public Message trace(String name) throws RemoteException {
        return null;
    }

    public String getName() throws RemoteException {
        return this.dsrServiceName;
    }

    public String getFqsn() throws RemoteException {
        return this.dsrServiceName;
    }

    class DiscoveryThread
    extends Thread {
        private RSSDistributedServiceRegistry dsr;
        private Service[] discoveryResult;
        private Message msg;

        protected DiscoveryThread(RSSDistributedServiceRegistry d, Message m) {
            this.dsr = d;
            this.msg = m;
        }

        public void run() {
            try {
                this.discoveryResult = this.dsr.discover(this.msg);
            }
            catch (RemoteException e) {
                e.printStackTrace();
                this.discoveryResult = new Service[0];
            }
        }

        public Service[] getResult() {
            return this.discoveryResult;
        }
    }
}

