/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.http;

import HTTPClient.HTTPResponse;
import HTTPClient.ModuleException;
import HTTPClient.ParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;

public class RSSHttpResponse {
    private String contentAsString;
    private HTTPResponse _resp;
    private String _encodingType;

    public RSSHttpResponse(HTTPResponse r, String encodingType) {
        this._resp = r;
        this._encodingType = encodingType;
    }

    public int getResponseCode() {
        int rc = 0;
        try {
            rc = this._resp.getStatusCode();
        }
        catch (Exception e) {
            rc = -1;
        }
        return rc;
    }

    public String getResponseMessage() {
        String s = null;
        try {
            s = this._resp.getReasonLine();
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }

    public String getText() throws IOException, ModuleException, ParseException {
        if (this.contentAsString == null) {
            InputStream in = this._resp.getInputStream();
            if (in == null) {
                return new String("");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "JISAutoDetect"));
            String line = "";
            StringBuffer buf = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                buf.append(line);
            }
            reader.close();
            this.contentAsString = new String(buf.toString());
        }
        return this.contentAsString;
    }

    public int getContentLength() {
        if (this.contentAsString == null) {
            return 0;
        }
        return this.contentAsString.length();
    }

    public String getContentType() {
        String s = null;
        try {
            s = this._resp.getHeader("Content-Type");
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }

    public URL getEffectiveURL() {
        URL u = null;
        try {
            u = this._resp.getEffectiveURI().toURL();
        }
        catch (Exception e) {
            u = null;
        }
        return u;
    }

    public URL getURL() {
        URL u = null;
        try {
            u = this._resp.getOriginalURI().toURL();
        }
        catch (Exception e) {
            u = null;
        }
        return u;
    }

    public Enumeration getHeaderKeys() {
        Enumeration e = null;
        try {
            e = this._resp.listHeaders();
        }
        catch (Exception ioe) {
            e = null;
        }
        return e;
    }

    public String getHeader(String key) {
        String s = null;
        try {
            s = this._resp.getHeader(key);
        }
        catch (Exception e) {
            s = null;
        }
        return s;
    }
}

