/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.logical_paradox.rss.http.RobotAcceptanceRule;

public class Site {
    private RobotAcceptanceRule robotstxt = null;
    private String siteName = null;
    private String url = null;
    private String robotstxtURL = null;
    public int siteScaleIndex = 0;

    protected Site(String u) {
        this.url = u;
    }

    public static Site getInstance(String url, String userAgent) throws IllegalArgumentException {
        Site s = new Site(url);
        URL u = null;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException ue) {
            throw new IllegalArgumentException(ue.getMessage());
        }
        s.siteName = String.valueOf(u.getHost()) + (u.getPort() > 0 ? ":" + u.getPort() : "");
        s.robotstxtURL = String.valueOf(u.getProtocol()) + "://" + s.siteName + "/" + "robots.txt";
        return s;
    }

    public String getSiteName() {
        return new String(this.siteName);
    }

    public String getRobotsTxtURL() {
        return new String(this.robotstxtURL);
    }

    public void getRuleFromTheSite(InputStream src) throws IOException {
        this.robotstxt = RobotAcceptanceRule.getInstance(src);
    }

    public boolean hasRule() {
        return this.robotstxt != null;
    }

    public boolean isAllowed(String url, String agent) {
        return this.robotstxt.isAllowed(url, agent);
    }
}

