/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.http;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class URLPool {
    private Hashtable domain = new Hashtable();

    public void add(String url) throws MalformedURLException {
        String dn = this.getDomainName(url);
        if (dn == null || dn.trim().length() == 0) {
            throw new MalformedURLException();
        }
        HashSet<String> s = (HashSet<String>)this.domain.get(dn);
        if (s == null) {
            s = new HashSet<String>();
            this.domain.put(dn, s);
        }
        s.add(url);
        Hashtable hashtable = this.domain;
        synchronized (hashtable) {
            this.domain.notifyAll();
        }
    }

    public void add(String[] urls) throws MalformedURLException {
        int i = 0;
        while (i < urls.length) {
            if (urls[i] != null) {
                this.add(urls[i]);
            }
            ++i;
        }
        Hashtable hashtable = this.domain;
        synchronized (hashtable) {
            this.domain.notifyAll();
        }
    }

    public void add(Iterator i) throws MalformedURLException {
        while (i.hasNext()) {
            this.add((String)i.next());
        }
        Hashtable hashtable = this.domain;
        synchronized (hashtable) {
            this.domain.notifyAll();
        }
    }

    public String[] domains(int idx, int len) {
        String[] d = this.domains();
        Vector<String> p = new Vector<String>();
        int i = 0;
        while (i < len && i < d.length) {
            p.addElement(d[i]);
            ++i;
        }
        return p.toArray(new String[0]);
    }

    public String[] domains() {
        Set keys = null;
        Hashtable hashtable = this.domain;
        synchronized (hashtable) {
            keys = this.domain.keySet();
        }
        if (keys == null) {
            return null;
        }
        return keys.toArray(new String[0]);
    }

    public String[] urls(String dn) {
        HashSet set = (HashSet)this.domain.get(dn);
        if (set == null) {
            return null;
        }
        return set.toArray(new String[0]);
    }

    public Iterator getURLIterator(String dn) {
        HashSet set = (HashSet)this.domain.get(dn);
        if (set == null) {
            return null;
        }
        return set.iterator();
    }

    protected String getDomainName(String url) throws MalformedURLException {
        URL u = new URL(url);
        String siteName = new String(u.getHost());
        return siteName;
    }

    public void remove(String url) throws MalformedURLException {
        String dn = this.getDomainName(url);
        if (dn == null || dn.trim().length() == 0) {
            throw new MalformedURLException();
        }
        HashSet set = (HashSet)this.domain.get(dn);
        if (set == null) {
            return;
        }
        set.remove(url);
        if (set.size() == 0) {
            this.domain.remove(dn);
        }
    }

    public void removeDomain(String domainname) {
        Hashtable hashtable = this.domain;
        synchronized (hashtable) {
            HashSet domainSet = (HashSet)this.domain.remove(domainname);
            if (domainSet != null) {
                domainSet.clear();
            }
        }
    }

    public int size() {
        int remain = 0;
        Hashtable hashtable = this.domain;
        synchronized (hashtable) {
            Enumeration e = this.domain.elements();
            while (e.hasMoreElements()) {
                HashSet s = (HashSet)e.nextElement();
                remain += s.size();
            }
        }
        return remain;
    }

    public boolean isEmpty() {
        boolean rc = false;
        Hashtable hashtable = this.domain;
        synchronized (hashtable) {
            rc = this.domain.isEmpty();
        }
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitUntilEmpty() {
        Hashtable hashtable = this.domain;
        synchronized (hashtable) {
            while (true) {
                if (!this.domain.isEmpty()) {
                    return;
                }
                try {
                    this.domain.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

