/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.http;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import org.logical_paradox.rss.IllegalObjectStateException;
import org.logical_paradox.rss.http.ContentsFilter;
import org.logical_paradox.rss.http.RSSHttpResponse;

public class WebContents {
    protected RSSHttpResponse res = null;
    protected String contents = null;
    protected LinkedList filters = new LinkedList();
    protected boolean robotstxtFlag = false;

    public WebContents() {
    }

    public WebContents(RSSHttpResponse c, String ct) throws IllegalObjectStateException, IOException {
        if (c.getResponseCode() < 0) {
            throw new IllegalObjectStateException("HttpURLConnection object has no content");
        }
        this.res = c;
        this.contents = ct;
        if (c.getURL().toString().indexOf("robots.txt") >= 0) {
            this.robotstxtFlag = true;
        }
    }

    public boolean isRobotsRule() {
        return this.robotstxtFlag;
    }

    public void addContentsFilter(ContentsFilter f) {
        this.filters.add(f);
    }

    public void removeContentsFilter(ContentsFilter f) {
        this.filters.remove(f);
    }

    public void attachResponse(RSSHttpResponse c) throws IllegalObjectStateException, IOException {
        if (c.getResponseCode() < 0) {
            throw new IllegalObjectStateException("HttpURLConnection object has no content");
        }
        this.res = c;
    }

    public void attachContents(String c) {
        this.contents = new String(c);
    }

    public String getWebContents() {
        if (this.contents == null) {
            return this.contents;
        }
        String src = new String(this.contents);
        int i = 0;
        while (i < this.filters.size()) {
            ContentsFilter f = (ContentsFilter)this.filters.get(i);
            src = new String(f.filter(src));
            ++i;
        }
        return src;
    }

    public int getResponseCode() throws IllegalObjectStateException, IOException {
        if (this.res == null) {
            throw new IllegalObjectStateException("no instance of HttpURLConnection");
        }
        return this.res.getResponseCode();
    }

    public String getResponseMessage() throws IllegalObjectStateException, IOException {
        if (this.res == null) {
            throw new IllegalObjectStateException("no instance of HttpURLConnection");
        }
        return this.res.getResponseMessage();
    }

    public int getContentLength() throws IllegalObjectStateException {
        if (this.res == null) {
            throw new IllegalObjectStateException("no instance of HttpURLConnection");
        }
        return this.res.getContentLength();
    }

    public String getContentType() throws IllegalObjectStateException {
        if (this.res == null) {
            throw new IllegalObjectStateException("no instance of HttpURLConnection");
        }
        return this.res.getContentType();
    }

    public URL getURL() throws IllegalObjectStateException {
        if (this.res == null) {
            throw new IllegalObjectStateException("no instance of HttpURLConnection");
        }
        return this.res.getURL();
    }

    public void close() {
        if (this.res != null) {
            this.res = null;
        }
        if (this.contents != null) {
            this.contents = null;
        }
    }

    public void finalize() {
        this.close();
    }
}

