/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.idxsv;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.RSSSubModule;
import org.logical_paradox.rss.idxsv.IndexConnection;
import org.logical_paradox.rss.idxsv.IndexConnectionImpl;
import org.logical_paradox.rss.idxsv.RSSIndexServer;
import org.logical_paradox.rss.idxsv.RSSIndexServerConfig;
import org.logical_paradox.rss.lookup.LookupFactory;

public class RSSIndexServerImpl
extends UnicastRemoteObject
implements RSSIndexServer,
RSSSubModule {
    private IndexConnection[] connections;
    private int nextConnectionIdx = 0;
    private RSSIndexServerConfig config;
    private String nodeId;

    protected RSSIndexServerImpl(RSSIndexServerConfig config) throws Exception {
        this.config = config;
        this.init();
    }

    protected void init() throws Exception {
        this.connections = new IndexConnection[this.config.getPreparedConnections()];
        int i = 0;
        while (i < this.connections.length) {
            this.connections[i] = new IndexConnectionImpl(this);
            ++i;
        }
    }

    public RSSIndexServerImpl() throws RemoteException {
        try {
            this.init();
        }
        catch (RemoteException re) {
            re.printStackTrace();
            throw re;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RemoteException(e.getMessage());
        }
    }

    public synchronized IndexConnection getClient() throws RemoteException {
        IndexConnection con = this.connections[this.nextConnectionIdx++];
        if (this.nextConnectionIdx >= this.connections.length) {
            this.nextConnectionIdx = 0;
        }
        return con;
    }

    public static void main(String[] args) throws Exception {
        new RSSIndexServerImpl().startModule();
    }

    public void startModule() throws ModuleException {
        try {
            RSSIndexServerConfig config = new RSSIndexServerConfig("conf/indexsrv.conf");
            this.nodeId = LookupFactory.getLookup(config.getDSR()).bind(30, this);
        }
        catch (Exception e) {
            throw new ModuleException(e.getMessage());
        }
    }

    public void suspendModule() throws ModuleException {
    }

    public void continueModule() throws ModuleException {
    }

    public void stopModule() throws ModuleException {
    }

    public String getName() throws RemoteException {
        return this.nodeId;
    }

    public String getFqsn() throws RemoteException {
        return String.valueOf(this.nodeId) + "@" + this.config.getDSR();
    }
}

