/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.logging;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Date;

public class RSSLogWriter {
    protected boolean loggingMode = true;
    protected boolean outToStdErr = true;
    protected OutputStream of = null;
    protected PrintWriter p = null;

    public RSSLogWriter(OutputStream o) {
        this.of = o;
        this.p = new PrintWriter(o);
    }

    public synchronized void write(Exception e) {
        Date now = Calendar.getInstance().getTime();
        String today = now.toString();
        if (this.outToStdErr) {
            System.err.print(String.valueOf(today) + " ");
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
        if (this.p != null && this.loggingMode) {
            this.p.print(String.valueOf(today) + " ");
            this.p.println(e.getMessage());
            this.p.print(String.valueOf(today) + " ");
            e.printStackTrace(this.p);
        }
    }

    public synchronized void write(String log) {
        Date now = Calendar.getInstance().getTime();
        String today = now.toString();
        if (this.outToStdErr) {
            System.err.print(String.valueOf(today) + " ");
            System.err.println(log);
        }
        if (this.p != null && this.loggingMode) {
            this.p.print(String.valueOf(today) + " ");
            this.p.println(log);
            this.p.flush();
        }
    }

    public void setLoggingMode(boolean m) {
        this.loggingMode = m;
    }

    public void enableEchoMode(boolean m) {
        this.outToStdErr = m;
    }
}

