/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.oqs4r;

import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.logical_paradox.common.util.Cache;
import org.logical_paradox.rss.lookup.LookupFactory;
import org.logical_paradox.rss.oqs4r.GC;
import org.logical_paradox.rss.oqs4r.OQS4RConfig;
import org.logical_paradox.rss.oqs4r.OQS4RLogWriter;
import org.logical_paradox.rss.oqs4r.OQSConnection;
import org.logical_paradox.rss.oqs4r.OQSConnectionImpl;
import org.logical_paradox.rss.oqs4r.ObjectQueueServer;

public class ObjectQueueServerImpl
extends UnicastRemoteObject
implements ObjectQueueServer {
    public static final String OQS4R_CONFIG_FILENAME = "conf/oqs4r.conf";
    private String nodeId = null;
    private GC gc;
    private OQS4RLogWriter logger;
    protected Cache queue = new Cache();
    protected OQSConnection[] preparedConnections = null;
    protected int nextidx = 0;
    protected OQS4RConfig config;

    protected ObjectQueueServerImpl() throws RemoteException {
    }

    public void start() throws Exception {
        this.config = new OQS4RConfig(OQS4R_CONFIG_FILENAME);
        this.nodeId = LookupFactory.getLookup(this.config.getDSRName()).bind(40, this);
        this.logger = new OQS4RLogWriter(new FileOutputStream("logs" + File.separator + this.config.getRunLogFilename()));
        this.logger.setLoggingMode(this.config.isEnableRunLog());
        int connections = this.config.getPreparedConnections();
        this.preparedConnections = new OQSConnection[connections];
        int i = 0;
        while (i < this.preparedConnections.length) {
            this.preparedConnections[i] = new OQSConnectionImpl(this);
            ++i;
        }
        this.logger.write("Object Queue Server ['" + this.nodeId + "']\u3092\u958b\u59cb\u3057\u307e\u3057\u305f");
        this.gc = new GC(this.logger, this.queue, this.config.getCacheExpireSec());
        this.gc.start();
    }

    public Serializable next() throws Exception {
        return this.next(false);
    }

    public Serializable next(boolean blocking) throws Exception {
        if (!blocking) {
            Cache cache = this.queue;
            synchronized (cache) {
                return (Serializable)this.queue.getOne();
            }
        }
        Serializable rc = null;
        Cache cache = this.queue;
        synchronized (cache) {
            while (this.queue.size() == 0) {
                this.queue.wait();
            }
            rc = (Serializable)this.queue.getOne();
            this.queue.notifyAll();
        }
        this.logger.write("\u30c7\u30ad\u30e5\u30fc:" + rc.toString());
        return rc;
    }

    public void add(Serializable o) throws Exception {
        this.queue.add((Object)o);
        this.logger.write("\u30a8\u30f3\u30ad\u30e5\u30fc:" + o.toString());
    }

    protected Cache getCache() {
        return this.queue;
    }

    public OQSConnection getConnection() throws RemoteException {
        OQSConnection aConnection = this.preparedConnections[this.nextidx++];
        if (this.nextidx >= this.preparedConnections.length) {
            this.nextidx = 0;
        }
        return aConnection;
    }

    public String getName() throws RemoteException {
        return this.nodeId;
    }

    public String getFqsn() throws RemoteException {
        return String.valueOf(this.nodeId) + "@" + this.config.getDSRName();
    }
}

