/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.rcm;

import java.rmi.Naming;
import java.rmi.RemoteException;
import org.logical_paradox.rss.dsr.RSSDistributedServiceRegistry;
import org.logical_paradox.rss.rcm.ContentsRegister;
import org.logical_paradox.rss.rcm.RSSContentsMngrService;

public class RCMContentsRegisterWrapper
implements ContentsRegister {
    private ContentsRegister register;

    public RCMContentsRegisterWrapper(String connstr) throws IllegalArgumentException {
        try {
            RSSDistributedServiceRegistry dsr = (RSSDistributedServiceRegistry)Naming.lookup(connstr);
            if (dsr == null) {
                throw new Exception("\u5206\u6563\u30b5\u30fc\u30d3\u30b9\u30ec\u30b8\u30b9\u30c8\u30ea\u3078\u306e\u63a5\u7d9a\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
            RSSContentsMngrService server = (RSSContentsMngrService)dsr.getService(20);
            if (server == null) {
                throw new Exception("\u30ea\u30e2\u30fc\u30c8\u30b3\u30f3\u30c6\u30f3\u30c4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u3078\u306e\u63a5\u7d9a\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
            this.register = server.getRegister();
            if (this.register == null) {
                throw new Exception("\u30b3\u30f3\u30c6\u30f3\u30c4\u767b\u9332\u30a4\u30f3\u30bf\u30fc\u30d5\u30a7\u30fc\u30b9\u53d6\u5f97\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public String getRegisterName() throws RemoteException {
        if (this.register == null) {
            throw new RemoteException("register\u304cnull");
        }
        return this.register.getRegisterName();
    }

    public void registContents(String url, String contents) throws RemoteException {
        if (url == null || url.trim().length() == 0 || contents == null || contents.trim().length() == 0) {
            return;
        }
        if (this.register == null) {
            throw new RemoteException("register\u304cnull");
        }
        this.register.registContents(url, contents);
    }

    public boolean isRegistered(String url) throws RemoteException {
        if (this.register == null) {
            throw new RemoteException("register\u304cnull");
        }
        return this.register.isRegistered(url);
    }

    public void unregistContents(String url) throws RemoteException {
        if (this.register == null) {
            throw new RemoteException("register\u304cnull");
        }
        this.register.unregistContents(url);
    }

    public void unregistAll() throws RemoteException {
        if (this.register == null) {
            throw new RemoteException("register\u304cnull");
        }
        this.register.unregistAll();
    }
}

