/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.rcm;

import java.io.File;
import java.io.FileOutputStream;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import org.logical_paradox.rss.ModuleException;
import org.logical_paradox.rss.RSSSubModule;
import org.logical_paradox.rss.logging.RSSLogWriter;
import org.logical_paradox.rss.lookup.LookupFactory;
import org.logical_paradox.rss.rcm.ContentsFinder;
import org.logical_paradox.rss.rcm.ContentsFinderImpl;
import org.logical_paradox.rss.rcm.ContentsRegister;
import org.logical_paradox.rss.rcm.RCMContentsRegisterImpl;
import org.logical_paradox.rss.rcm.RSSContentsMngrService;
import org.logical_paradox.rss.rcm.RSSRCMConfig;
import org.logical_paradox.rss.rcm.RSSRCMLogWriter;
import org.logical_paradox.rss.rcm.accessor.ContentsAccessorFactory;

public class RSSContentsMngrServiceImpl
extends UnicastRemoteObject
implements RSSContentsMngrService,
RSSSubModule {
    public static String RCM_CONF_FILENAME = "conf/rssrcm.conf";
    private String rcmServiceName = null;
    private RSSRCMConfig cfg = null;
    private int registerServiceCnt = 1;
    private int finderServiceCnt = 1;
    private ContentsAccessorFactory accessorFactory = null;
    private Vector registers = null;
    private Vector finders = null;
    private int registerIdx = 0;
    private int finderIdx = 0;

    protected void init() throws Exception {
        this.registers = new Vector();
        this.finders = new Vector();
        RSSRCMLogWriter.setLogWriter(new RSSLogWriter(new FileOutputStream("logs" + File.separator + this.cfg.getRCMRunLogFilename(), true)));
        RSSRCMLogWriter.setLoggingMode(this.cfg.getRCMSwRunLog());
        RSSRCMLogWriter.write("\u30ed\u30b0\u30e9\u30a4\u30bf\u30fc\u3092\u521d\u671f\u5316\u3057\u307e\u3057\u305f");
        this.accessorFactory = (ContentsAccessorFactory)Class.forName(this.cfg.getContentsAccessorFactory()).newInstance();
        this.accessorFactory.setDefaultFactoryParam(this.cfg.getContentsConnStr());
        this.accessorFactory.setRCMServiceName(this.getFqsn());
        RSSRCMLogWriter.write("\u30b3\u30f3\u30c6\u30f3\u30c4\u30a2\u30af\u30bb\u30b5\u30d5\u30a1\u30af\u30c8\u30ea[" + this.cfg.getContentsAccessorFactory() + "]\u3092\u30ed\u30fc\u30c9\u3057\u307e\u3057\u305f");
        RSSRCMLogWriter.write("\u30ea\u30e2\u30fc\u30c8\u30b3\u30f3\u30c6\u30f3\u30c4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u3092\u69cb\u6210\u3057\u3066\u3044\u307e\u3059");
        int i = 0;
        while (i < this.cfg.getInitialRegisterServices()) {
            this.createRegister();
            ++i;
        }
        int j = 0;
        while (j < this.cfg.getInitialFinderServices()) {
            this.createFinder();
            ++j;
        }
    }

    protected void createFinder() throws Exception {
        Vector vector = this.finders;
        synchronized (vector) {
            String serviceName = "FINDER_" + (this.finders.size() + 1);
            this.finders.addElement(new ContentsFinderImpl(serviceName, this.accessorFactory.getAccessor()));
            RSSRCMLogWriter.write("\u30d5\u30a1\u30a4\u30f3\u30c0\u30fc[" + serviceName + "]\u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f");
            ++this.finderServiceCnt;
        }
    }

    protected void createRegister() throws Exception {
        String serviceName = String.valueOf(this.cfg.getRegisterServicePrefix()) + this.registerServiceCnt;
        RCMContentsRegisterImpl r = new RCMContentsRegisterImpl(serviceName, this.cfg, this.accessorFactory.getAccessor());
        this.registers.addElement(r);
        Naming.bind(serviceName, r);
        RSSRCMLogWriter.write("\u30ec\u30b8\u30b9\u30bf\u30b5\u30fc\u30d3\u30b9[" + serviceName + "]\u3092\u8ffd\u52a0\u3057\u307e\u3057\u305f");
        ++this.registerServiceCnt;
    }

    public String[] getRegisterNames() throws RemoteException {
        return null;
    }

    public void gc() throws RemoteException {
    }

    public ContentsFinder getFinder() throws RemoteException {
        if (this.finderIdx >= this.finders.size()) {
            this.finderIdx = 0;
        }
        ContentsFinder finder = (ContentsFinder)this.finders.elementAt(this.finderIdx++);
        RSSRCMLogWriter.write("\u30d5\u30a1\u30a4\u30f3\u30c0\u30fc\u30b5\u30fc\u30d3\u30b9[" + finder.getName() + "\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f");
        return finder;
    }

    public ContentsRegister getRegister() throws RemoteException {
        if (this.registerIdx >= this.registers.size()) {
            this.registerIdx = 0;
        }
        ContentsRegister r = (ContentsRegister)this.registers.elementAt(this.registerIdx++);
        RSSRCMLogWriter.write("\u30ec\u30b8\u30b9\u30bf\u30b5\u30fc\u30d3\u30b9[" + r.getRegisterName() + "]\u304c\u9078\u629e\u3055\u308c\u307e\u3057\u305f");
        return r;
    }

    public static void main(String[] args) throws Exception {
        RSSContentsMngrServiceImpl server = new RSSContentsMngrServiceImpl();
        server.startModule();
    }

    public void startModule() throws ModuleException {
        try {
            this.cfg = new RSSRCMConfig(RCM_CONF_FILENAME);
            this.rcmServiceName = LookupFactory.getLookup(this.cfg.getRSSDistributedServiceRegistry()).bind(20, this);
            this.init();
        }
        catch (Exception e) {
            throw new ModuleException(e);
        }
        RSSRCMLogWriter.write("\u30ea\u30e2\u30fc\u30c8\u30b3\u30f3\u30c6\u30f3\u30c4\u7ba1\u7406\u30b7\u30b9\u30c6\u30e0\u3092\u958b\u59cb\u3057\u307e\u3057\u305f");
    }

    public void suspendModule() throws ModuleException {
    }

    public void continueModule() throws ModuleException {
    }

    public void stopModule() throws ModuleException {
    }

    public String getName() throws RemoteException {
        return this.rcmServiceName;
    }

    public String getFqsn() throws RemoteException {
        return String.valueOf(this.rcmServiceName) + "@" + this.cfg.getRSSDistributedServiceRegistry();
    }
}

