/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.rcm.accessor.simple;

import java.util.Properties;
import org.logical_paradox.common.btree.BtreeAvailableList;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeFactory;
import org.logical_paradox.common.btree.BtreeFile;
import org.logical_paradox.common.btree.BtreeKey;
import org.logical_paradox.rss.rcm.accessor.simple.RCMBtreeKey;

public class RCMBtreeFactory
extends BtreeFactory {
    private static Properties _prop = new Properties();

    static {
        _prop.setProperty("btreefile.magicnumber", "RCMF");
        _prop.setProperty("btreefile.majorversion", "1");
        _prop.setProperty("btreefile.minorversion", "0");
        _prop.setProperty("btreefile.headersize", "128");
        _prop.setProperty("btreefile.order", "32");
        _prop.setProperty("btreefile.keysize", "40");
    }

    protected Properties getProperty() throws BtreeException {
        return (Properties)_prop.clone();
    }

    public BtreeFile getFileHandle(String filename) throws BtreeException {
        if (filename == null || filename.trim().length() == 0) {
            throw new BtreeException("\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        Properties p = (Properties)_prop.clone();
        p.setProperty("btreefile.filename", filename);
        BtreeFile bf = new BtreeFile((BtreeFactory)this, p);
        return bf;
    }

    public BtreeAvailableList getBtreeAvailableList(String filename) throws BtreeException {
        return new BtreeAvailableList(filename);
    }

    public BtreeKey newKey(Object o) throws BtreeException {
        return new RCMBtreeKey(o);
    }

    public BtreeKey newKey(byte[] stream) throws BtreeException {
        return new RCMBtreeKey(stream);
    }

    public int keyByteSize() {
        return 40;
    }
}

