/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.rcm.accessor.simple;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.logical_paradox.common.btree.BtreeException;
import org.logical_paradox.common.btree.BtreeKey;

public class RCMBtreeKey
extends BtreeKey {
    public static final int KEY_BYTE_SIZE = 40;
    private String _key;
    private long _offset;

    public RCMBtreeKey(Object o) throws BtreeException {
        super(o);
    }

    public RCMBtreeKey(byte[] bstream) throws BtreeException {
        super(bstream);
    }

    protected void objectToBtreeKey(Object o) throws BtreeException {
        this._key = ((String)o).trim();
    }

    protected void byteStreamToBtreeKey(byte[] bstream) throws BtreeException {
        ByteBuffer buffer = ByteBuffer.allocate(bstream.length).order(ByteOrder.BIG_ENDIAN);
        buffer.put(bstream);
        buffer.rewind();
        this._offset = buffer.getLong();
        byte[] strbuf = new byte[bstream.length - 8];
        buffer.get(strbuf);
        this._key = new String(strbuf).trim();
    }

    public String toString() {
        return this._key.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof String) {
            String s = (String)obj;
            return this._key.equals(s.trim());
        }
        if (obj instanceof BtreeKey) {
            String s = ((BtreeKey)obj).toString().trim();
            return this._key.equals(s);
        }
        return false;
    }

    public boolean isLessThan(BtreeKey key) {
        return this._key.compareTo(key.toString().trim()) < 0;
    }

    public boolean isGreaterThan(BtreeKey key) {
        return this._key.compareTo(key.toString().trim()) > 0;
    }

    public byte[] byteStream() {
        ByteBuffer buffer = ByteBuffer.allocate(40).order(ByteOrder.BIG_ENDIAN);
        buffer.putLong(this._offset);
        buffer.put(this._key.getBytes());
        return buffer.array();
    }

    public void setOffset(long offset) {
        this._offset = offset;
    }

    public long getOffset() {
        return this._offset;
    }

    public int byteSize() {
        return 40;
    }
}

