/*
 * Decompiled with CFR 0.152.
 */
package org.logical_paradox.rss.rcm.df;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.logical_paradox.common.io.ExpandableBuffer;
import org.logical_paradox.common.security.Digester;
import org.logical_paradox.rss.rcm.df.DataFilter;

public class GZIPDataFilter
implements DataFilter {
    public String filterURL(String url) {
        return Digester.getInstance((String)"md5").getDigest(url);
    }

    public byte[] compressContents(String contents) throws Exception {
        ExpandableBuffer buffer = new ExpandableBuffer();
        GZIPOutputStream gout = new GZIPOutputStream(buffer.getOutputStream());
        gout.write(contents.getBytes());
        gout.finish();
        gout.close();
        return buffer.byteStream();
    }

    public String decompressContents(byte[] b) throws Exception {
        return this.decompressContents(b, null);
    }

    public String decompressContents(byte[] b, String encoding) throws Exception {
        BufferedInputStream reader = new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(b)));
        ExpandableBuffer buffer = new ExpandableBuffer();
        int bf = 0;
        while ((bf = reader.read()) >= 0) {
            buffer.write(bf);
        }
        reader.close();
        if (encoding == null) {
            return new String(buffer.byteStream());
        }
        return new String(buffer.byteStream(), encoding);
    }
}

